package org.hibernate.auction.persistence;

import net.sf.hibernate.Session;
import org.apache.commons.logging.*;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.IOException;

/**
 * Filtr serwletowy rozczajcy i ponownie czcy sesj Hibernate dla kadego dania
 * <p>
 * Uyj filtru we wzorcu <b>sesja na transakcje aplikacyjn</b> z
 * <i>dug sesj</i>. Nie zappomnij odpowiednio oznacza transakcji aplikacyjnych w kodzie.
 *
 * @see HibernateUtil
 * @author Christian Bauer <christian@hibernate.org>
 */
public class HibernateFilterLong
		implements Filter {

	private static final String HTTPSESSIONKEY = "HibernateSession";
	private static Log log = LogFactory.getLog(HibernateFilterLong.class);

	public void init(FilterConfig filterConfig) throws ServletException {
		log.info("Inicjalizacja filtru serwletu, rozcza i ponownie czy sesj dla kadego dania.");
	}

	public void doFilter(ServletRequest request,
						 ServletResponse response,
						 FilterChain chain)
			throws IOException, ServletException {

		// Sprbuj pobra sesj z HttpSession.
		HttpSession userSession =
				((HttpServletRequest) request).getSession();
		Session hibernateSession =
				(Session) userSession.getAttribute(HTTPSESSIONKEY);

		if (hibernateSession != null)
			HibernateUtil.reconnect(hibernateSession);

		// Jeli nie ma sesji, pierwsze wywoanie
		// HibernateUtil.beginTransaction w kodzie aplikacji spowoduje
		// utworzenie nowej sesji dla wtku.
		try {
			chain.doFilter(request, response);

			// Zatwierd oczekujc transakcj bazodanow.
			HibernateUtil.commitTransaction();

		} finally {
			// TODO: Sesj naley zamkn w przypadku bdu krytycznego.

			// Niezalenie od tego, co si stanie, odcz sesj
			hibernateSession = HibernateUtil.disconnectSession();
			// i zapamitaj j w obiekcie HttpSession.
			userSession.setAttribute(HTTPSESSIONKEY, hibernateSession);
		}
	}

	public void destroy() {}

}
