package org.hibernate.auction.persistence;

import org.apache.commons.logging.*;

import javax.servlet.*;
import java.io.IOException;

/**
 * Filtr serwletowy otwierajcy i zamykajcy sesj Hibernate.
 * <p>
 * Filtr gwarantuje poprawny stan, zatiwrdzajc wszystkie transakcje bazodanowe
 * po wykonaniu wszystkich innych filtrw i serwletw. Zapewnia rwnie
 * zamknicie oniektu <tt>Session</tt> aktualnego wtku przed wysaniem
 * odpowiedzi do klienta.
 * <p>
 * Uywaj filtru we wzorcu <b>sesja na kade danie</b> lub gdy uywasz
 * <i>obiektw odczonych</i>.
 *
 * @see HibernateUtil
 * @author Christian Bauer <christian@hibernate.org>
 */
public class HibernateFilter implements Filter {

	private static Log log = LogFactory.getLog(HibernateFilter.class);

	public void init(FilterConfig filterConfig) throws ServletException {
		log.info("Inicjalizacja filtru serwletu, otwiera i zamyka sesj dla kadego dania.");
	}

	public void doFilter(ServletRequest request,
						 ServletResponse response,
						 FilterChain chain)
			throws IOException, ServletException {

		// W zasadzie nie ma jawnego otwarcia sesji. Pierwsze wywoanie
		// HibernateUtil.beginTransaction() z logiki sterujcej
		// utworzy nowy obiekt sesji.
		try {
			chain.doFilter(request, response);

			// Zatwierd oczekujc transakcj bazodanow.
			HibernateUtil.commitTransaction();

		} finally {

			// Niezalenie od tego, co si stanie, zamknij sesj.
			HibernateUtil.closeSession();

		}
	}

	public void destroy() {}

}
