package org.hibernate.auction.persistence;

import net.sf.hibernate.cfg.NamingStrategy;
import net.sf.hibernate.util.StringHelper;

/**
 * Tworzy przedrostki dla nazw kolumn i tabel bazy danych aplikacji CaveatEmptor.
 * <p>
 * Jest to implementacja interfejsu Hibernate <tt>NamingStrategy</tt>.
 * Hibernate wywouj t klas przy tworzeniu schematu bazy danych.
 * Wszystkie nazwy tabel zostaj poprzedzone tekstem "CE_" przy zachowaniu
 * ddomylnych nazw waciwoci pisanych wielk liter. Aby wczy strategi,
 * ustaw j w obiekcie <tt>SessionFactory</tt>, oto przykad:
 * <tt>HibernateUtil</tt>:
 * <p>
 * <pre>
 *    configuration = new Configuration();
 *    configuration.setNamingStrategy(new CENamingStrategy());
 *    sessionFactory = configuration.configure().buildSessionFactory();
 *
 * </pre>
 * Oglnie <tt>NamingStrategy</tt> okazuje si bardzo uyteczne, bo daje swobod
 * nazewnictwa tabel i kolumn wedug wasnych standardw.
 *
 * @see HibernateUtil
 * @author Christian Bauer <christian@hibernate.org>
 */
public class CENamingStrategy implements NamingStrategy {

	public String classToTableName(String className) {
		return StringHelper.unqualify(className);
	}

	public String propertyToColumnName(String propertyName) {
	    return propertyName;
    }

	public String tableName(String tableName) {
		return "CE_" + tableName;
	}

	public String columnName(String columnName) {
	    return columnName;
    }

	public String propertyToTableName(String className, String propertyName) {
		return "CE_"
				+ classToTableName(className)
				+ '_'
				+ propertyToColumnName(propertyName);
	}

}
