package org.hibernate.auction.model;

import java.math.BigDecimal;
import java.util.Currency;
import java.io.Serializable;

/**
 * Reprezentuje kwot jako poczenie wartoci i waluty.
 *
 * @author Gavin King <gavin@hibernate.org>
 * @author Christian Bauer <christian@hibernate.org>
 */
public class MonetaryAmount implements Serializable {

	private final BigDecimal value;
	private final Currency currency;

	public MonetaryAmount(BigDecimal value, Currency currency) {
		this.value = value;
		this.currency = currency;
	}

	public Currency getCurrency() {
		return currency;
	}

	public BigDecimal getValue() {
		return value;
	}

	// ********************** Typowe metody ********************** //

	public boolean equals(Object o) {
		if (this == o) return true;
		if (!(o instanceof MonetaryAmount)) return false;

		final MonetaryAmount monetaryAmount = (MonetaryAmount) o;

		if (!currency.equals(monetaryAmount.currency)) return false;
		if (!value.equals(monetaryAmount.value)) return false;

		return true;
	}

	public int hashCode() {
		int result;
		result = value.hashCode();
		result = 29 * result + currency.hashCode();
		return result;
	}

	public String toString() {
		return "Kwota: '" + getValue() + "', " +
		        "Waluta: '" + getCurrency() + "'";
	}

	public int compareTo(Object o) {
		if (o instanceof MonetaryAmount) {
			// TODO: Tak naprawd powinna pojawi si tu rzeczywista konwersja walut.
			return this.getValue().compareTo(((MonetaryAmount) o).getValue());
		}
		return 0;
	}

	// ********************** Metody biznesowe ********************** //

	public static MonetaryAmount fromString(String amount, String currencyCode) {
		return new MonetaryAmount(new BigDecimal(amount),
								  Currency.getInstance(currencyCode));
	}

	public static MonetaryAmount convert(MonetaryAmount amount,
										 Currency toConcurrency) {
		// TODO: Wymaga wykonania rzeczywistej konwersji walut.
		return new MonetaryAmount(amount.getValue(), toConcurrency);
	}

}
