package org.hibernate.auction.model;

import java.io.Serializable;
import java.util.*;

/**
 * Bezpieczne pod wzgldem typu wyliczenie rodzaj kart kredytowych.
 *
 * @author Christian Bauer <christian@hibernate.org>
 */
public class CreditCardType implements Serializable {

	private final int code;
	private final String debugName;

	public static final CreditCardType MASTERCARD = new CreditCardType(1, "Mastercard");
	public static final CreditCardType VISA = new CreditCardType(2, "Visa");
	public static final CreditCardType AMEX = new CreditCardType(3, "American Express");

	private static final Map INSTANCES = new HashMap();

	static {
		INSTANCES.put(MASTERCARD.toInteger(), MASTERCARD);
		INSTANCES.put(VISA.toInteger(), VISA);
		INSTANCES.put(AMEX.toInteger(), AMEX);
	}

	/**
	 * Konstruktor prywatny zapobiega tworzeniu egzemplarzy i dziedziczeniu.
	 */
	private CreditCardType(int code, String debugName) {
		this.debugName = debugName;
		this.code = code;
	}

	// ********************** Typowe metody ********************** //

	public String toString() {
	    return debugName;
	}

	public Integer toInteger() {
		return new Integer(code);
	}

	Object readResolve() {
		return getInstance(code);
	}

	public static CreditCardType getInstance(int code) {
		return (CreditCardType) INSTANCES.get(new Integer(code));
	}

	// ********************** Metody biznesowe ********************** //

	public boolean isValid(CreditCard cc) {
		// TODO: Implementacja metody sprawdzajcej poprawno numeru karty kredytowej.
		return true;
	}

}
