package org.hibernate.auction.model;

/**
 * Ta strategia patnoci obsuguje kilka rnych kart kredytowych.
 * <p>
 * Typ karty kredytowej zawiera bezpieczne pod ktem typw wyliczenie
 * <tt>CreditCardType</tt>.
 *
 * @see CreditCardType
 * @author Christian Bauer <christian@hibernate.org>
 */
public class CreditCard extends BillingDetails {

	private CreditCardType type;
	private String number;
	private String expMonth;
	private String expYear;

	/**
	 * Konstruktor bezparametrowy dla narzdzi JavaBean.
	 */
	CreditCard() { super(); }

	/**
	 * Peny konstruktor.
	 *
	 * @param ownerName
	 * @param user
	 * @param type
	 * @param expMonth
	 * @param expYear
	 */
	public CreditCard(String ownerName, User user, String number, CreditCardType type,
					  String expMonth, String expYear) {
		super(ownerName, user);
		this.type = type;
		this.number = number;
		this.expMonth = expMonth;
		this.expYear = expYear;
	}

	// ********************** Metody dostpowe ********************** //

	public CreditCardType getType() { return type; }

	public String getNumber() { return number; }

	public String getExpMonth() { return expMonth; }

	public String getExpYear() { return expYear; }

	// ********************** Inne typowe metody ********************** //

	public String toString() {
		return  "CreditCard ('" + getId() + "'), " +
				"Typ: '" + getType() + "'";
	}

	// ********************** Metody biznesowe ********************** //

	public boolean isValid() {
		// Uyj typu do walidacji numeru karty kredytowej.
		return getType().isValid(this);
	}

}
