package org.hibernate.auction.model;

import java.io.Serializable;
import java.util.Date;

/**
 * Abstrakcyjna klasa bazowa szczegw patnoci.
 * <p>
 * Obiekt jest zawsze powizany z konkretnym uytkownikiem i w peni
 * zaley od jego cyklu ycia. Reprezentuje jedn ze strategii patnoci
 * wybran przez uytkownika. Najczciej klas t odwzorowuje si jako kolekcj.
 *
 * @author Christian Bauer <christian@hibernate.org>
 */
public abstract class BillingDetails implements Serializable, Comparable {

	private Long id = null;
	private int version;
	private String ownerName;
	private User user;
	private Date created = new Date();

	/**
	 * Konstruktor bezparametrowy dla narzdzi JavaBean.
	 */
	BillingDetails() {}

	/**
	 * Peny konstruktor.
	 */
	protected BillingDetails(String ownerName, User user) {
		this.ownerName = ownerName;
		this.user = user;
	}

	// ********************** Metody dostpowe ********************** //

	public Long getId() { return id; }

	public String getOwnerName() { return ownerName; }
	public void setOwnerName(String ownerName) { this.ownerName = ownerName; }

	public User getUser() { return user; }

	public Date getCreated() { return created; }

	// ********************** Inne typowe metody ********************** //

	public boolean equals(Object o) {
		if (this == o) return true;
		if (!(o instanceof BillingDetails)) return false;

		final BillingDetails billingDetails = (BillingDetails) o;

		if (!getCreated().equals(billingDetails.getCreated())) return false;
		if (!getOwnerName().equals(billingDetails.getOwnerName())) return false;

		return true;
	}

	public int hashCode() {
		int result;
		result = getCreated().hashCode();
		result = 29 * result + getOwnerName().hashCode();
		return result;
	}

	public int compareTo(Object o) {
		// Szczegy patnoci sortuje si na podstawie daty utworzenia.
		if (o instanceof BillingDetails)
			return getCreated().compareTo( ((BillingDetails)o).getCreated() );
		return 0;
	}

	// ********************** Metody biznesowe ********************** //

	/**
	 * Sprawdza, czy dane patnoci s poprawne.
	 * <p>
	 * Konkretny algorytm implementuj podklasy.
	 *
	 * @return boolean
	 */
	public abstract boolean isValid();

}
