package org.hibernate.auction.model;

import java.io.Serializable;
import java.util.Date;

/**
 * Klasa niezmienna reprezentujca zoon ofert.
 * <p>
 * Uwaga: Klasa wymaga prywatnej metody ustawiajcej dla Hibernate. Jest 
 * odwzorowana jako komponent przedmiotu, wic nie moemy ustawi "update" na false.
 *
 * @see Item
 * @see User
 * @author Christian Bauer <christian@hibernate.org>
 */
public class Bid implements Serializable, Comparable {

	private Long id = null;
	private MonetaryAmount amount;
	private Item item;
	private User bidder;
	private Date created = new Date();

	/**
	 * Konstruktor bezparametrowy dla narzdzi JavaBean.
	 */
	Bid() {}

	/**
	 * Peny konstruktor.
	 *
	 * @param amount
	 * @param item
	 * @param bidder
	 */

	public Bid(MonetaryAmount amount, Item item, User bidder) {
		this.amount = amount;
		this.item = item;
		this.bidder = bidder;
	}

	// ********************** Metody dostpowe ********************** //

	public Long getId() { return id; }

	public MonetaryAmount getAmount() { return amount; }
	public Item getItem() { return item; }
	public User getBidder() { return bidder; }
	public Date getCreated() { return created; }

	// ********************** Inne typowe metody ********************** //

	public boolean equals(Object o) {
		if (this == o) return true;
		if (!(o instanceof Bid)) return false;

		final Bid bid = (Bid) o;

		if (!amount.equals(bid.amount)) return false;
		if (!created.equals(bid.created)) return false;

		return true;
	}

	public int hashCode() {
		int result;
		result = amount.hashCode();
		result = 29 * result + created.hashCode();
		return result;
	}

	public String toString() {
		return  "Bid ('" + getId() + "'), " +
				"Zoony: '" + getCreated() + "' " +
				"Kwota: '" + getAmount() + "'";
	}

	public int compareTo(Object o) {
		if (o instanceof Bid) {
			return this.getCreated().compareTo( ((Bid)o).getCreated() );
		}
		return 0;
	}

	// ********************** Metody biznesowe ********************** //


}
