package org.hibernate.auction.test;

import junit.framework.*;
import junit.textui.TestRunner;
import org.hibernate.auction.model.*;
import org.hibernate.auction.persistence.HibernateUtil;

import java.util.*;

import net.sf.hibernate.*;

public class CategoryItemTest extends TestCaseWithData {

	// ********************************************************** //

	public void testCompositeQuery() throws Exception {
		initData();

		// Zapytanie o Category i wszystkie obiekty Item w kategoriach (zczenie trzech tabel).
		HibernateUtil.beginTransaction();
		Session s = HibernateUtil.getSession();

		Query q = s.createQuery("select c from Category as c left join fetch c.categorizedItems as ci join fetch ci.item as i");
		Collection result = new HashSet(q.list());
		assertTrue(result.size() == 2);

		HibernateUtil.commitTransaction();
		HibernateUtil.closeSession();

		// Sprawdzenie inicjalizacji (powinno pobra wszystko z wyprzedzeniem.)
		for (Iterator it = result.iterator(); it.hasNext();) {
			Category cat = (Category) it.next();
			for (Iterator it2 = cat.getCategorizedItems().iterator(); it2.hasNext();) {
				assertTrue(it2.next() != null);
			}
		}
	}

	public void testDeletionFromItem() throws Exception {
		initData();

		// Usunicie wszystkich cz dla auctionFour przez wyczyszczenie kolekcji.
		HibernateUtil.beginTransaction();
		Session s = HibernateUtil.getSession();
		Item i = (Item)s.get(Item.class, auctionFour.getId());
		i.getCategorizedItems().clear();
		HibernateUtil.commitTransaction();
		HibernateUtil.closeSession();

		// Sprawdzenie usunicia.
		HibernateUtil.beginTransaction();
		s = HibernateUtil.getSession();
		CategorizedItem catItem = (CategorizedItem)s.get(CategorizedItem.class,
					new CategorizedItem.Id(carsLuxury.getId(), auctionFour.getId()));
		assertTrue(catItem == null);
		HibernateUtil.commitTransaction();
		HibernateUtil.closeSession();
	}

	public void testDeletionFromCategory() throws Exception {
		initData();

		// Usunicie wszystkich cz dla auctionFour przez wyczyszczenie kolekcji.
		HibernateUtil.beginTransaction();
		Session s = HibernateUtil.getSession();
		Category c = (Category)s.get(Category.class, carsSUV.getId());
		c.getCategorizedItems().clear();
		HibernateUtil.commitTransaction();
		HibernateUtil.closeSession();

		// Sprawdzenie usunicia.
		HibernateUtil.beginTransaction();
		s = HibernateUtil.getSession();
		CategorizedItem catItem = (CategorizedItem)s.get(CategorizedItem.class,
					new CategorizedItem.Id(carsSUV.getId(), auctionThree.getId()));
		assertTrue(catItem == null);
		HibernateUtil.commitTransaction();
		HibernateUtil.closeSession();

	}

	// ********************************************************** //

	public CategoryItemTest(String x) {
		super(x);
	}

	public static Test suite() {
		return new TestSuite(CategoryItemTest.class);
	}

	public static void main(String[] args) throws Exception {
		TestRunner.run( suite() );
	}

}
