package org.hibernate.auction.persistence.audit;

import net.sf.hibernate.*;

import java.io.Serializable;
import java.sql.Connection;

import org.hibernate.auction.persistence.HibernateUtil;
import org.hibernate.auction.model.Auditable;

/**
 * Klasa pomocnicza dziennika audytowego, ktra zapisuje wpisy.
 * <p>
 * Metoda <tt>logEvent()</tt> wymaga poczenia JDBC. Otwiera now
 * sesj Hibernate dla poczenia i zapisuje wpis.
 * Tymczasowa sesja zostaje zamknita, a obsuga transakcyjna pozostaje
 * w rkach klienta.
 *
 * @author Christian Bauer <christian@hibernate.org>
 */
public class AuditLog {

	public static void logEvent(
		String message,
		Auditable entity,
		Long userId,
		Connection connection)
		throws CallbackException {

		Session tempSession =
		  HibernateUtil.getSessionFactory().openSession(connection);

		try {
			AuditLogRecord record =
				new AuditLogRecord(message,
								   entity.getId(),
								   entity.getClass(),
								   userId );

			tempSession.save(record);
			tempSession.flush();

		} catch (Exception ex) {
			throw new CallbackException(ex);

		} finally {
			try {
				tempSession.close();
			} catch (HibernateException ex) {
				throw new CallbackException(ex);
			}
		}
	}
}
