package org.hibernate.auction.model;

import java.io.Serializable;
import java.util.Date;

/**
 * Niezmienna klasa reprezentujca komentarz uytkownika.
 * <p>
 * Komentarze zawsze powstaj w kontekcie aukcji, wic komentarz zawiera
 * referencj do Item. Komentarz skada si z pola tekstowego i oceny
 * (wartoci typu wyliczeniowego).
 *
 * @see Item
 * @see User
 * @see Rating
 * @author Christian Bauer <christian@hibernate.org>
 */
public class Comment implements Serializable, Comparable {

	private Long id = null;
	private int version;
	private Rating rating;
	private String text;
	private User fromUser;
	private Item item;
	private Date created = new Date();

	/**
	 * Konstruktor bezparametrowy dla narzdzi JavaBean.
	 */
	Comment() {
	}

	/**
	 * Peny konstruktor.
	 *
	 * @param rating
	 * @param text
	 * @param fromUser
	 * @param item
	 */
	public Comment(Rating rating, String text, User fromUser, Item item) {
		this.rating = rating;
		this.text = text;
		this.fromUser = fromUser;
		this.item = item;
	}

	// ********************** Metody dostpowe ********************** //

	public Long getId() { return id; }

	public Rating getRating() { return rating; }

	public String getText() { return text; }
	public void setText(String text) {
		this.text = text;
	}

	public User getFromUser() { return fromUser; }

	public Item getItem() { return item; }

	public Date getCreated() { return created; }

	// ********************** Inne typowe metody ********************** //

	public boolean equals(Object o) {
		if (this == o) return true;
		if (!(o instanceof Comment)) return false;

		final Comment comment = (Comment) o;

		if (!created.equals(comment.created)) return false;
		if (!rating.equals(comment.rating)) return false;
		if (text != null ? !text.equals(comment.text) : comment.text != null) return false;

		return true;
	}

	public int hashCode() {
		int result;
		result = rating.hashCode();
		result = 29 * result + (text != null ? text.hashCode() : 0);
		result = 29 * result + created.hashCode();
		return result;
	}

	public String toString() {
		return "Comment ('" + getId() + "'), " +
				"Ocena: '" + getRating() + "'";
	}

	public int compareTo(Object o) {
		if (o instanceof Comment) {
			return this.getCreated().compareTo(((Comment) o).getCreated());
		}
		return 0;
	}

	// ********************** Metody biznesowe ********************** //

}
