package org.hibernate.auction.model;

/**
 * Ta strategia patnoci uywa prostego konta bankowego.
 *
 * @author Christian Bauer <christian@hibernate.org>
 */
public class BankAccount extends BillingDetails {

	private String number;
	private String bankName;
	private String bankSwift;

	/**
	 * Konstruktor bezparametrowy dla narzdzi JavaBean.
	 */
	BankAccount() { super(); }

	/**
	 * Peny konstruktor.
	 *
	 * @param ownerName
	 * @param user
	 * @param number
	 * @param bankName
	 * @param bankSwift
	 */
	public BankAccount(String ownerName, User user, String number, String bankName, String bankSwift) {
		super(ownerName, user);
		this.number = number;
		this.bankName = bankName;
		this.bankSwift = bankSwift;
	}

	// ********************** Metody dostpowe ********************** //

	public String getNumber() { return number; }
	public void setNumber(String number) { this.number = number; }

	public String getBankName() { return bankName; }
	public void setBankName(String bankName) { this.bankName = bankName; }

	public String getBankSwift() { return bankSwift; }
	public void setBankSwift(String bankSwift) { this.bankSwift = bankSwift; }

	// ********************** Inne typowe metody ********************** //

	public String toString() {
		return  "BankAccount ('" + getId() + "'), " +
				"Numer: '" + getNumber() + "'";
	}

	// ********************** Metody biznesowe ********************** //

	public boolean isValid() {
		// TODO: Walidacja numeru konta bankowego.
		return true;
	}

}
