package org.hibernate.auction.command;

import org.hibernate.auction.persistence.HibernateUtil;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * Implementacja oglnego uchwytu polece EJB.
 *
 * @author Christian Bauer <christian@hibernate.org>
 */
public class CommandHandlerBean
	implements SessionBean, CommandHandler{

	public void setSessionContext(SessionContext sessionContext)
					throws EJBException, RemoteException {}
	public void ejbRemove()
					throws EJBException, RemoteException {}
	public void ejbActivate()
					throws EJBException, RemoteException {}
	public void ejbPassivate()
					throws EJBException, RemoteException {}

	public Command executeCommand(Command command)
		throws RemoteException, CommandException {

		try {
			command.execute();
		} catch (CommandException ex) {
			// W rzeczywistoci ustaw UserTransaction z JTA w tryb wycofania.
			// Mona nie wyapywa wyjtku, by to sam kontener
			// wczy wycofanie po nieudanym wykonaniu metody.
			HibernateUtil.rollbackTransaction();
			throw ex;
		}
		return command;
	}
}
