/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.hsqldb.util.SqlFile;
import org.hsqldb.util.SqlToolError;

public class SqlTool {
    private static final String DEFAULT_JDBC_DRIVER = "org.hsqldb.jdbcDriver";
    private static Connection conn;
    private static boolean noexit;
    private static final String DEFAULT_RCFILE;
    private static final String SYNTAX_MESSAGE = "Usage: java [-Dsqlfile.charset=x.y.z*] org.hsqldb.util.SqlTool \\\n    [--optname [optval...]] urlid [file1.sql...]\nwhere arguments are:\n    --help                   Prints this message\n    --list                   List urlids in the rcfile\n    --noinput                Do not read stdin (dflt if sql file(s) given)\n    --debug                  Print Debug info to stderr\n    --sql \"SQL;\"             Execute given SQL before stdin/files,\n                             where \"SQL;\" consists of SQL command(s) like\n                             in an SQL file, and may contain line breaks\n    --rcfile /file/path.rc   Connect Info File [$HOME/sqltool.rc]\n    --driver a.b.c.Driver*   JDBC driver class [org.hsqldb.jdbcDriver]\n    urlid                    ID of url/userame/password in rcfile\n    file1.sql...             SQL files to be executed [stdin]\n                             (Use '-' for non-interactively stdin)\n* items may, alternatively, be set per-urlid in the rc file.";
    private static BadCmdline bcl;

    private static void exitMain(int n) throws SqlToolException {
        SqlTool.exitMain(n, null);
    }

    private static void exitMain(int n, String string) throws SqlToolException {
        if (noexit) {
            if (n == 0) {
                return;
            }
            if (string == null) {
                throw new SqlToolException();
            }
            throw new SqlToolException(string);
        }
        if (string != null) {
            (n == 0 ? System.out : System.err).println(string);
        }
        System.exit(n);
    }

    public static void main(String[] stringArray) throws SqlToolException {
        int n;
        int n2;
        File[] fileArray;
        String string = null;
        File file = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        File[] fileArray2 = null;
        int n3 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        noexit = System.getProperty("sqltool.noexit") != null;
        try {
            while (n3 + 1 < stringArray.length && stringArray[n3 + 1].startsWith("--") && stringArray[++n3].length() != 2) {
                if (stringArray[n3].substring(2).equals("help")) {
                    SqlTool.exitMain(0, SYNTAX_MESSAGE);
                    return;
                }
                if (stringArray[n3].substring(2).equals("list")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[n3].substring(2).equals("rcfile")) {
                    if (++n3 == stringArray.length) {
                        throw bcl;
                    }
                    string = stringArray[n3];
                    continue;
                }
                if (stringArray[n3].substring(2).equals("sql")) {
                    if (++n3 == stringArray.length) {
                        throw bcl;
                    }
                    string2 = stringArray[n3];
                    continue;
                }
                if (stringArray[n3].substring(2).equals("debug")) {
                    bl = true;
                    continue;
                }
                if (stringArray[n3].substring(2).equals("noinput")) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[n3].substring(2).equals("driver")) {
                    if (++n3 == stringArray.length) {
                        throw bcl;
                    }
                    string3 = stringArray[n3];
                    continue;
                }
                throw bcl;
            }
            if (!bl2) {
                if (++n3 == stringArray.length) {
                    throw bcl;
                }
                string4 = stringArray[n3];
            }
            int n4 = 0;
            if (string2 != null) {
                try {
                    file = File.createTempFile("sqltool-", ".sql");
                    fileArray = new FileWriter(file);
                    fileArray.write(string2);
                    fileArray.flush();
                    fileArray.close();
                }
                catch (IOException iOException) {
                    SqlTool.exitMain(4, "Failed to write given sql to temp file: " + iOException);
                    return;
                }
            }
            boolean bl5 = bl3 = stringArray.length <= n3 + 1;
            if (!(stringArray.length <= n3 + 1 || stringArray.length == n3 + 2 && stringArray[n3 + 1].equals("-"))) {
                bl4 = true;
                fileArray2 = new File[stringArray.length - n3 - 1];
                if (bl) {
                    System.err.println("scriptFiles has " + fileArray2.length + " elements");
                }
                while (n3 + 1 < stringArray.length) {
                    fileArray2[n4++] = new File(stringArray[++n3]);
                }
            }
        }
        catch (BadCmdline badCmdline) {
            SqlTool.exitMain(2, SYNTAX_MESSAGE);
            return;
        }
        ConnectData connectData = null;
        try {
            connectData = new ConnectData(string, string4);
        }
        catch (Exception exception) {
            SqlTool.exitMain(1, "Failed to retrieve connection info for database '" + string4 + "': " + exception.getMessage());
            return;
        }
        if (bl2) {
            SqlTool.exitMain(0);
            return;
        }
        if (bl) {
            connectData.report();
        }
        if (string3 == null) {
            String string5 = string3 = connectData.driver == null ? DEFAULT_JDBC_DRIVER : connectData.driver;
        }
        if (System.getProperty("sqlfile.charset") == null && connectData.charset != null) {
            System.setProperty("sqlfile.charset", connectData.charset);
        }
        try {
            Class.forName(string3).newInstance();
            conn = DriverManager.getConnection(connectData.url, connectData.username, connectData.password);
        }
        catch (Exception exception) {
            SqlTool.exitMain(10, "Failed to get a connection to " + connectData.url + ".  " + exception.getMessage());
            return;
        }
        fileArray = new File[]{};
        File[] fileArray3 = new File[]{null};
        if (fileArray2 == null) {
            fileArray2 = bl4 ? fileArray : fileArray3;
        }
        SqlFile[] sqlFileArray = new SqlFile[fileArray2.length + (file == null ? 0 : 1)];
        try {
            n2 = 0;
            if (file != null) {
                sqlFileArray[n2++] = new SqlFile(file, false);
            }
            for (n = 0; n < fileArray2.length; ++n) {
                sqlFileArray[n2++] = new SqlFile(fileArray2[n], bl3);
            }
        }
        catch (IOException iOException) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SqlTool.exitMain(2, iOException.getMessage());
            return;
        }
        n2 = 0;
        try {
            for (n = 0; n < sqlFileArray.length; ++n) {
                sqlFileArray[n].execute(conn);
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to execute SQL:  " + iOException.getMessage());
            n2 = 3;
        }
        catch (SqlToolError sqlToolError) {
            n2 = 2;
        }
        catch (SQLException sQLException) {
            n2 = 1;
        }
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file != null && !file.delete()) {
            System.err.println("Error occurred while trying to remove temp file '" + file + "'");
        }
        SqlTool.exitMain(n2);
    }

    static {
        DEFAULT_RCFILE = System.getProperty("user.home") + "/sqltool.rc";
        bcl = new BadCmdline();
    }

    public static class SqlToolException
    extends Exception {
        public SqlToolException() {
        }

        public SqlToolException(String string) {
            super(string);
        }
    }

    private static class BadCmdline
    extends Exception {
        private BadCmdline() {
        }
    }

    private static class ConnectData {
        String id = null;
        String url = null;
        String username = null;
        String password = null;
        String driver = null;
        String charset = null;

        public void report() {
            System.err.println("urlid: " + this.id + ", url: " + this.url + ", username: " + this.username + ", password: " + this.password);
        }

        public ConnectData(String string, String string2) throws Exception {
            String string3;
            File file = new File(string == null ? DEFAULT_RCFILE : string);
            if (!file.canRead()) {
                throw new IOException("Please set up authentication file '" + file + "'");
            }
            StringTokenizer stringTokenizer = null;
            boolean bl = false;
            int n = 0;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                String string4;
                String string5;
                ++n;
                if ((string3 = string3.trim()).length() == 0 || string3.charAt(0) == '#') continue;
                stringTokenizer = new StringTokenizer(string3);
                if (stringTokenizer.countTokens() == 1) {
                    string5 = stringTokenizer.nextToken();
                    string4 = "";
                } else if (stringTokenizer.countTokens() == 2) {
                    string5 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                } else {
                    throw new Exception("Bad line " + n + " in '" + file + "':  " + string3);
                }
                if (string2 == null) {
                    if (!string5.equals("urlid")) continue;
                    System.out.println(string4);
                    continue;
                }
                if (string5.equals("urlid")) {
                    if (string4.equals(string2)) {
                        if (this.id == null) {
                            this.id = string2;
                            bl = true;
                            continue;
                        }
                        throw new Exception("Key '" + string2 + " redefined at" + " line " + n + " in '" + file);
                    }
                    bl = false;
                    continue;
                }
                if (!bl) continue;
                if (string5.equals("url")) {
                    this.url = string4;
                    continue;
                }
                if (string5.equals("username")) {
                    this.username = string4;
                    continue;
                }
                if (string5.equals("driver")) {
                    this.driver = string4;
                    continue;
                }
                if (string5.equals("charset")) {
                    this.charset = string4;
                    continue;
                }
                if (string5.equals("password")) {
                    this.password = string4;
                    continue;
                }
                throw new Exception("Bad line " + n + " in '" + file + "':  " + string3);
            }
            if (string2 == null) {
                return;
            }
            if (this.url == null || this.username == null || this.password == null) {
                throw new Exception("url or username or password not set for '" + string2 + "' in file '" + file + "'");
            }
        }
    }
}

