/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Trace;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.Iterator;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Result {
    public Record rRoot;
    private Record rTail;
    private int iSize;
    private int significantColumns;
    public int iMode;
    int databaseID;
    int sessionID;
    String mainString;
    String subString;
    String subSubString;
    int statementID;
    int iUpdateCount;
    public ResultMetaData metaData;

    public Result(int n) {
        this.iMode = n;
        if (n == 3 || n == 5 || n == 65548 || n == 6) {
            this.metaData = new ResultMetaData();
        }
    }

    Result(ResultMetaData resultMetaData) {
        this.iMode = 3;
        this.significantColumns = resultMetaData.colType.length;
        this.metaData = resultMetaData;
    }

    Result(String string, String string2, int n) {
        this.iMode = 2;
        this.mainString = string;
        this.subString = string2;
        this.statementID = n;
        this.subSubString = "";
    }

    Result(int n, int n2) {
        this.metaData = new ResultMetaData();
        this.metaData.prepareData(n2);
        if (n == 5) {
            this.metaData.isParameterDescription = true;
            this.metaData.paramMode = new int[n2];
        }
        this.iMode = n;
        this.significantColumns = n2;
    }

    public Result(int n, int[] nArray, int n2) {
        this.iMode = n;
        this.metaData = new ResultMetaData();
        this.metaData.colType = nArray;
        this.significantColumns = nArray.length;
        this.statementID = n2;
    }

    Result(RowInputBinary rowInputBinary) throws HsqlException {
        try {
            this.iMode = rowInputBinary.readIntData();
            if (this.iMode == 0) {
                this.readMultiResult(rowInputBinary);
                return;
            }
            this.databaseID = rowInputBinary.readIntData();
            this.sessionID = rowInputBinary.readIntData();
            switch (this.iMode) {
                case 7: 
                case 65545: 
                case 65610: {
                    break;
                }
                case 65555: {
                    this.setStatementType(rowInputBinary.readIntData());
                    this.mainString = rowInputBinary.readString();
                    break;
                }
                case 4: 
                case 65552: {
                    this.statementID = rowInputBinary.readIntData();
                    break;
                }
                case 65547: {
                    this.iUpdateCount = rowInputBinary.readIntData();
                    this.statementID = rowInputBinary.readIntData();
                    this.mainString = rowInputBinary.readString();
                    break;
                }
                case 2: 
                case 65543: {
                    this.mainString = rowInputBinary.readString();
                    this.subString = rowInputBinary.readString();
                    this.subSubString = rowInputBinary.readString();
                    this.statementID = rowInputBinary.readIntData();
                    break;
                }
                case 1: {
                    this.iUpdateCount = rowInputBinary.readIntData();
                    break;
                }
                case 66541: {
                    int n = rowInputBinary.readIntData();
                    this.setEndTranType(n);
                    switch (n) {
                        case 2: 
                        case 4: {
                            this.mainString = rowInputBinary.readString();
                        }
                    }
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 65548: {
                    int n;
                    this.iUpdateCount = rowInputBinary.readIntData();
                    this.statementID = rowInputBinary.readIntData();
                    int n2 = rowInputBinary.readIntData();
                    this.metaData = new ResultMetaData(n2);
                    this.significantColumns = n2;
                    for (n = 0; n < n2; ++n) {
                        this.metaData.colType[n] = rowInputBinary.readType();
                    }
                    n = rowInputBinary.readIntData();
                    while (n-- > 0) {
                        this.add(rowInputBinary.readData(this.metaData.colType));
                    }
                    break;
                }
                case 3: 
                case 5: {
                    this.metaData = new ResultMetaData();
                    this.metaData.isParameterDescription = this.iMode == 5;
                    this.metaData.read(rowInputBinary);
                    this.significantColumns = this.metaData.sLabel.length;
                    int n = rowInputBinary.readIntData();
                    while (n-- > 0) {
                        this.add(rowInputBinary.readData(this.metaData.colType));
                    }
                    break;
                }
                case 66552: {
                    int n = rowInputBinary.readIntData();
                    this.setConnectionAttrType(n);
                    switch (n) {
                        case 10027: {
                            this.mainString = rowInputBinary.readString();
                        }
                    }
                    break;
                }
                default: {
                    throw new HsqlException(Trace.getMessage(146, true, new Object[]{new Integer(this.iMode)}), null, 0);
                }
            }
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
    }

    static Result newSingleColumnResult(String string, int n) {
        Result result = new Result(3, 1);
        result.metaData.sName[0] = string;
        result.metaData.sLabel[0] = string;
        result.metaData.sTable[0] = "";
        result.metaData.colType[0] = n;
        return result;
    }

    static Result newPrepareResponse(int n, Result result, Result result2) {
        Result result3 = new Result(0);
        Result result4 = new Result(4);
        result4.statementID = n;
        result3.add(new Object[]{result4});
        result3.add(new Object[]{result});
        result3.add(new Object[]{result2});
        return result3;
    }

    static Result newParameterDescriptionResult(int n) {
        Result result = new Result(5, n);
        result.metaData.isParameterDescription = true;
        result.metaData.paramMode = new int[n];
        return result;
    }

    public static Result newFreeStmtRequest(int n) {
        Result result = new Result(65552);
        result.statementID = n;
        return result;
    }

    static Result newExecuteDirectRequest(String string) {
        Result result = new Result(65547);
        result.setMainString(string);
        return result;
    }

    public static Result newReleaseSavepointRequest(String string) {
        Result result = new Result(66541);
        result.setMainString(string);
        result.setEndTranType(4);
        return result;
    }

    public static Result newRollbackToSavepointRequest(String string) {
        Result result = new Result(66541);
        result.setMainString(string);
        result.setEndTranType(2);
        return result;
    }

    public static Result newSetSavepointRequest(String string) {
        Result result = new Result(66552);
        result.setConnectionAttrType(10027);
        result.setMainString(string);
        return result;
    }

    public int getSize() {
        return this.iSize;
    }

    void setColumnCount(int n) {
        this.significantColumns = n;
    }

    public int getColumnCount() {
        return this.significantColumns;
    }

    void append(Result result) {
        if (this.rRoot == null) {
            this.rRoot = result.rRoot;
        } else {
            this.rTail.next = result.rRoot;
        }
        this.rTail = result.rTail;
        this.iSize += result.iSize;
    }

    void addAll(Result result) {
        if (result == null) {
            return;
        }
        Record record = result.rRoot;
        while (record != null) {
            this.add(record.data);
            record = record.next;
        }
    }

    public void clear() {
        this.rRoot = null;
        this.rTail = null;
        this.iSize = 0;
    }

    public boolean isEmpty() {
        return this.rRoot == null;
    }

    void setRows(Result result) {
        if (result == null) {
            this.rRoot = null;
            this.rTail = null;
            this.iSize = 0;
        } else {
            this.rRoot = result.rRoot;
            this.rTail = result.rTail;
            this.iSize = result.iSize;
        }
    }

    public void add(Object[] objectArray) {
        Record record = new Record();
        record.data = objectArray;
        if (this.rRoot == null) {
            this.rRoot = record;
        } else {
            this.rTail.next = record;
        }
        this.rTail = record;
        ++this.iSize;
    }

    void trimResult(int n, int n2) {
        int n3;
        Record record = this.rRoot;
        if (record == null) {
            return;
        }
        if (n >= this.iSize) {
            this.iSize = 0;
            this.rTail = null;
            this.rRoot = null;
            return;
        }
        this.iSize -= n;
        for (n3 = 0; n3 < n; ++n3) {
            record = record.next;
            if (record != null) continue;
            this.iSize = 0;
            this.rRoot = this.rTail = record;
            return;
        }
        this.rRoot = record;
        if (n2 == 0 || n2 >= this.iSize) {
            return;
        }
        for (n3 = 1; n3 < n2; ++n3) {
            record = record.next;
            if (record != null) continue;
            return;
        }
        this.iSize = n2;
        record.next = null;
        this.rTail = record;
    }

    void removeDuplicates() throws HsqlException {
        this.removeDuplicates(this.significantColumns);
    }

    void removeDuplicates(int n) throws HsqlException {
        Record record;
        if (this.rRoot == null) {
            return;
        }
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
            nArray2[i] = 1;
        }
        this.sortResult(nArray, nArray2);
        Record record2 = this.rRoot;
        while ((record = record2.next) != null) {
            if (this.compareRecord(record2.data, record.data, n) == 0) {
                record2.next = record.next;
                --this.iSize;
                continue;
            }
            record2 = record;
        }
        this.rTail = record2;
    }

    void removeSecond(Result result, int n) throws HsqlException {
        this.removeDuplicates(n);
        result.removeDuplicates(n);
        Record record = this.rRoot;
        Record record2 = this.rRoot;
        boolean bl = true;
        Record record3 = result.rRoot;
        int n2 = 0;
        while (record != null && record3 != null) {
            n2 = this.compareRecord(record.data, record3.data, n);
            if (n2 == 0) {
                if (bl) {
                    this.rRoot = record2 = record.next;
                } else {
                    record2.next = record.next;
                }
                record = record.next;
                --this.iSize;
                continue;
            }
            if (n2 > 0) {
                record3 = record3.next;
                continue;
            }
            record2 = record;
            bl = false;
            record = record.next;
        }
        while (record != null) {
            record2 = record;
            record = record.next;
        }
        this.rTail = record2;
    }

    void removeDifferent(Result result, int n) throws HsqlException {
        this.removeDuplicates(n);
        result.removeDuplicates(n);
        Record record = this.rRoot;
        Record record2 = this.rRoot;
        boolean bl = true;
        Record record3 = result.rRoot;
        int n2 = 0;
        this.iSize = 0;
        while (record != null && record3 != null) {
            n2 = this.compareRecord(record.data, record3.data, n);
            if (n2 == 0) {
                if (bl) {
                    this.rRoot = record;
                } else {
                    record2.next = record;
                }
                bl = false;
                record2 = record;
                record = record.next;
                record3 = record3.next;
                ++this.iSize;
                continue;
            }
            if (n2 > 0) {
                record3 = record3.next;
                continue;
            }
            record = record.next;
        }
        if (bl) {
            this.rRoot = null;
            record2 = null;
        } else {
            record2.next = null;
        }
        this.rTail = record2;
    }

    void sortResult(int[] nArray, int[] nArray2) throws HsqlException {
        if (this.rRoot == null || this.rRoot.next == null) {
            return;
        }
        Record[] recordArray = new Record[2];
        Record[] recordArray2 = new Record[2];
        int n = 0;
        Record record = this.rRoot;
        while (record != null) {
            Record record2 = record.next;
            record.next = recordArray[n];
            recordArray[n] = record;
            record = record2;
            n ^= 1;
        }
        int n2 = 1;
        while (recordArray[1] != null) {
            Record record3 = recordArray[0];
            Record record4 = recordArray[1];
            recordArray2[1] = null;
            recordArray2[0] = null;
            recordArray[1] = null;
            recordArray[0] = null;
            n = 0;
            while (record3 != null) {
                int n3 = n2;
                int n4 = n2;
                while (true) {
                    if (n3 == 0 || record3 == null) {
                        if (n4 == 0 || record4 == null) break;
                        record = record4;
                        record4 = record4.next;
                        --n4;
                    } else if (n4 == 0 || record4 == null) {
                        record = record3;
                        record3 = record3.next;
                        --n3;
                    } else if (this.compareRecord(record3.data, record4.data, nArray, nArray2) > 0) {
                        record = record4;
                        record4 = record4.next;
                        --n4;
                    } else {
                        record = record3;
                        record3 = record3.next;
                        --n3;
                    }
                    if (recordArray[n] == null) {
                        recordArray[n] = record;
                    } else {
                        recordArray2[n].next = record;
                    }
                    recordArray2[n] = record;
                    record.next = null;
                }
                n ^= 1;
            }
            n2 <<= 1;
        }
        this.rRoot = recordArray[0];
        this.rTail = recordArray2[0];
    }

    private int compareRecord(Object[] objectArray, Object[] objectArray2, int[] nArray, int[] nArray2) throws HsqlException {
        int n = Column.compare(objectArray[nArray[0]], objectArray2[nArray[0]], this.metaData.colType[nArray[0]]);
        if (n == 0) {
            for (int i = 1; i < nArray.length; ++i) {
                n = Column.compare(objectArray[nArray[i]], objectArray2[nArray[i]], this.metaData.colType[nArray[i]]);
                if (n == 0) continue;
                return n * nArray2[i];
            }
        }
        return n * nArray2[0];
    }

    private int compareRecord(Object[] objectArray, Object[] objectArray2, int n) throws HsqlException {
        for (int i = 0; i < n; ++i) {
            int n2 = Column.compare(objectArray[i], objectArray2[i], this.metaData.colType[i]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    void write(RowOutputBinary rowOutputBinary) throws IOException, HsqlException {
        if (this.iMode == 0) {
            this.writeMulti(rowOutputBinary);
            return;
        }
        int n = rowOutputBinary.size();
        rowOutputBinary.writeSize(0);
        rowOutputBinary.writeIntData(this.iMode);
        rowOutputBinary.writeIntData(this.databaseID);
        rowOutputBinary.writeIntData(this.sessionID);
        switch (this.iMode) {
            case 7: 
            case 65545: 
            case 65610: {
                break;
            }
            case 65555: {
                rowOutputBinary.writeIntData(this.getStatementType());
                rowOutputBinary.writeString(this.mainString);
                break;
            }
            case 4: 
            case 65552: {
                rowOutputBinary.writeIntData(this.statementID);
                break;
            }
            case 65547: {
                rowOutputBinary.writeIntData(this.iUpdateCount);
                rowOutputBinary.writeIntData(this.statementID);
                rowOutputBinary.writeString(this.mainString);
                break;
            }
            case 2: 
            case 65543: {
                rowOutputBinary.writeString(this.mainString);
                rowOutputBinary.writeString(this.subString);
                rowOutputBinary.writeString(this.subSubString);
                rowOutputBinary.writeIntData(this.statementID);
                break;
            }
            case 1: {
                rowOutputBinary.writeIntData(this.iUpdateCount);
                break;
            }
            case 66541: {
                int n2 = this.getEndTranType();
                rowOutputBinary.writeIntData(n2);
                switch (n2) {
                    case 2: 
                    case 4: {
                        rowOutputBinary.writeString(this.mainString);
                    }
                }
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 65548: {
                rowOutputBinary.writeIntData(this.iUpdateCount);
                rowOutputBinary.writeIntData(this.statementID);
                int n3 = this.significantColumns;
                rowOutputBinary.writeIntData(n3);
                for (int i = 0; i < n3; ++i) {
                    rowOutputBinary.writeType(this.metaData.colType[i]);
                }
                rowOutputBinary.writeIntData(this.iSize);
                Record record = this.rRoot;
                while (record != null) {
                    rowOutputBinary.writeData(n3, this.metaData.colType, record.data, null, false);
                    record = record.next;
                }
                break;
            }
            case 3: 
            case 5: {
                this.metaData.write(rowOutputBinary, this.significantColumns);
                rowOutputBinary.writeIntData(this.iSize);
                Record record = this.rRoot;
                while (record != null) {
                    rowOutputBinary.writeData(this.significantColumns, this.metaData.colType, record.data, null, false);
                    record = record.next;
                }
                break;
            }
            case 66552: {
                int n4 = this.getConnectionAttrType();
                rowOutputBinary.writeIntData(n4);
                switch (n4) {
                    case 10027: {
                        rowOutputBinary.writeString(this.mainString);
                    }
                }
                break;
            }
            default: {
                throw new HsqlException(Trace.getMessage(146, true, new Object[]{new Integer(this.iMode)}), null, 0);
            }
        }
        rowOutputBinary.writeIntData(rowOutputBinary.size(), n);
    }

    void readMultiResult(RowInputBinary rowInputBinary) throws HsqlException, IOException {
        this.iMode = 0;
        this.databaseID = rowInputBinary.readIntData();
        this.sessionID = rowInputBinary.readIntData();
        int n = rowInputBinary.readIntData();
        for (int i = 0; i < n; ++i) {
            rowInputBinary.readIntData();
            this.add(new Object[]{new Result(rowInputBinary)});
        }
    }

    private void writeMulti(RowOutputBinary rowOutputBinary) throws IOException, HsqlException {
        int n = rowOutputBinary.size();
        rowOutputBinary.writeSize(0);
        rowOutputBinary.writeIntData(this.iMode);
        rowOutputBinary.writeIntData(this.databaseID);
        rowOutputBinary.writeIntData(this.sessionID);
        rowOutputBinary.writeIntData(this.iSize);
        Record record = this.rRoot;
        while (record != null) {
            ((Result)record.data[0]).write(rowOutputBinary);
            record = record.next;
        }
        rowOutputBinary.writeIntData(rowOutputBinary.size(), n);
    }

    public static void write(Result result, RowOutputBinary rowOutputBinary, OutputStream outputStream) throws IOException, HsqlException {
        rowOutputBinary.reset();
        result.write(rowOutputBinary);
        outputStream.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.getOutputStream().size());
        outputStream.flush();
    }

    public static Result read(RowInputBinary rowInputBinary, InputStream inputStream) throws IOException, HsqlException {
        int n;
        int n2 = InOutUtil.readInt(inputStream);
        rowInputBinary.resetRow(0, n2);
        byte[] byArray = rowInputBinary.getBuffer();
        for (int i = 4; i < n2; i += n) {
            n = inputStream.read(byArray, i, n2 - i);
            if (n >= 0) continue;
            throw new IOException();
        }
        return new Result(rowInputBinary);
    }

    public Result(Throwable throwable, String string) {
        this.iMode = 2;
        if (throwable instanceof HsqlException) {
            HsqlException hsqlException = (HsqlException)throwable;
            this.subString = hsqlException.state;
            this.mainString = hsqlException.message;
            if (string != null) {
                this.mainString = this.mainString + " in statement [" + string + "]";
            }
            this.statementID = hsqlException.code;
        } else if (throwable instanceof Exception) {
            throwable.printStackTrace();
            this.subString = "S1000";
            this.mainString = Trace.getMessage(40) + " " + throwable;
            if (string != null) {
                this.mainString = this.mainString + " in statement [" + string + "]";
            }
            this.statementID = 40;
        } else if (throwable instanceof OutOfMemoryError) {
            System.gc();
            throwable.printStackTrace();
            this.subString = "S1000";
            this.mainString = "out of memory";
            this.statementID = 72;
        }
        this.subSubString = "";
    }

    public int getStatementID() {
        return this.statementID;
    }

    void setStatementID(int n) {
        this.statementID = n;
    }

    public String getMainString() {
        return this.mainString;
    }

    public void setMainString(String string) {
        this.mainString = string;
    }

    public String getSubString() {
        return this.subString;
    }

    public void setMaxRows(int n) {
        this.iUpdateCount = n;
    }

    public int getUpdateCount() {
        return this.iUpdateCount;
    }

    int getConnectionAttrType() {
        return this.iUpdateCount;
    }

    void setConnectionAttrType(int n) {
        this.iUpdateCount = n;
    }

    int getEndTranType() {
        return this.iUpdateCount;
    }

    void setEndTranType(int n) {
        this.iUpdateCount = n;
    }

    public int[] getUpdateCounts() {
        return this.metaData.colType;
    }

    Object[] getParameterData() {
        return this.rRoot == null ? null : this.rRoot.data;
    }

    public void setParameterData(Object[] objectArray) {
        if (this.rRoot == null) {
            this.rRoot = new Record();
        }
        this.rRoot.data = objectArray;
        this.rRoot.next = null;
        this.rTail = this.rRoot;
        this.iSize = 1;
    }

    public void setResultType(int n) {
        this.iMode = n;
    }

    public void setStatementType(int n) {
        this.iUpdateCount = n;
    }

    public int getStatementType() {
        return this.iUpdateCount;
    }

    public Iterator iterator() {
        return new ResultIterator();
    }

    private class ResultIterator
    implements Iterator {
        boolean removed;
        int counter;
        Record current;
        Record last;

        private ResultIterator() {
            this.current = Result.this.rRoot;
        }

        public boolean hasNext() {
            return this.counter < Result.this.iSize;
        }

        public Object next() {
            if (this.hasNext()) {
                this.removed = false;
                if (this.counter != 0) {
                    this.last = this.current;
                    this.current = this.current.next;
                }
                ++this.counter;
                return this.current.data;
            }
            throw new NoSuchElementException();
        }

        public int nextInt() {
            throw new NoSuchElementException();
        }

        public long nextLong() {
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.counter <= Result.this.iSize && this.counter != 0 && !this.removed) {
                this.removed = true;
                if (this.current == Result.this.rTail) {
                    Result.this.rTail = this.last;
                }
                if (this.current == Result.this.rRoot) {
                    this.current = Result.this.rRoot = Result.this.rRoot.next;
                } else {
                    this.current = this.last;
                    this.last = null;
                    this.current.next = this.current.next.next;
                }
                Result.this.iSize--;
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }
    }

    public static class ResultMetaData {
        public String[] sLabel;
        public String[] sTable;
        public String[] sName;
        public boolean[] isLabelQuoted;
        public int[] colType;
        public int[] colSize;
        public int[] colScale;
        public String[] sCatalog;
        public String[] sSchema;
        public int[] nullability;
        public boolean[] isIdentity;
        public boolean[] isWritable;
        public int[] paramMode;
        public String[] sClassName;
        boolean isParameterDescription;

        ResultMetaData() {
        }

        ResultMetaData(int n) {
            this.prepareData(n);
        }

        private void prepareData(int n) {
            this.sLabel = new String[n];
            this.sTable = new String[n];
            this.sName = new String[n];
            this.isLabelQuoted = new boolean[n];
            this.colType = new int[n];
            this.colSize = new int[n];
            this.colScale = new int[n];
            this.sCatalog = new String[n];
            this.sSchema = new String[n];
            this.nullability = new int[n];
            this.isIdentity = new boolean[n];
            this.isWritable = new boolean[n];
            this.sClassName = new String[n];
        }

        public int[] getParameterTypes() {
            return this.colType;
        }

        boolean isTableColumn(int n) {
            return this.sTable[n] != null && this.sTable[n].length() > 0 && this.sName[n] != null && this.sName[n].length() > 0;
        }

        private void decodeTableColumnAttrs(int n, int n2) {
            this.nullability[n2] = n & 0xF;
            this.isIdentity[n2] = (n & 0x10) != 0;
            this.isWritable[n2] = (n & 0x20) != 0;
        }

        private void writeTableColumnAttrs(RowOutputBinary rowOutputBinary, int n) throws IOException, HsqlException {
            rowOutputBinary.writeIntData(this.encodeTableColumnAttrs(n));
            rowOutputBinary.writeString(this.sCatalog[n] == null ? "" : this.sCatalog[n]);
            rowOutputBinary.writeString(this.sSchema[n] == null ? "" : this.sSchema[n]);
        }

        private int encodeTableColumnAttrs(int n) {
            int n2 = this.nullability[n];
            if (this.isIdentity[n]) {
                n2 |= 0x10;
            }
            if (this.isWritable[n]) {
                n2 |= 0x20;
            }
            return n2;
        }

        private void readTableColumnAttrs(RowInputBinary rowInputBinary, int n) throws IOException, HsqlException {
            this.decodeTableColumnAttrs(rowInputBinary.readIntData(), n);
            this.sCatalog[n] = rowInputBinary.readString();
            this.sSchema[n] = rowInputBinary.readString();
        }

        void read(RowInputBinary rowInputBinary) throws HsqlException, IOException {
            int n = rowInputBinary.readIntData();
            this.prepareData(n);
            if (this.isParameterDescription) {
                this.paramMode = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                this.colType[i] = rowInputBinary.readType();
                this.sLabel[i] = rowInputBinary.readString();
                this.sTable[i] = rowInputBinary.readString();
                this.sName[i] = rowInputBinary.readString();
                this.sClassName[i] = rowInputBinary.readString();
                if (this.isTableColumn(i)) {
                    this.readTableColumnAttrs(rowInputBinary, i);
                }
                if (!this.isParameterDescription) continue;
                this.paramMode[i] = rowInputBinary.readIntData();
            }
        }

        void write(RowOutputBinary rowOutputBinary, int n) throws HsqlException, IOException {
            rowOutputBinary.writeIntData(n);
            for (int i = 0; i < n; ++i) {
                rowOutputBinary.writeType(this.colType[i]);
                rowOutputBinary.writeString(this.sLabel[i] == null ? "" : this.sLabel[i]);
                rowOutputBinary.writeString(this.sTable[i] == null ? "" : this.sTable[i]);
                rowOutputBinary.writeString(this.sName[i] == null ? "" : this.sName[i]);
                rowOutputBinary.writeString(this.sClassName[i] == null ? "" : this.sClassName[i]);
                if (this.isTableColumn(i)) {
                    this.writeTableColumnAttrs(rowOutputBinary, i);
                }
                if (!this.isParameterDescription) continue;
                rowOutputBinary.writeIntData(this.paramMode[i]);
            }
        }
    }
}

