/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.Loader;
import net.sf.hibernate.loader.UniqueEntityLoader;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchingEntityLoader
implements UniqueEntityLoader {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$loader$BatchingEntityLoader == null ? (class$net$sf$hibernate$loader$BatchingEntityLoader = BatchingEntityLoader.class$("net.sf.hibernate.loader.BatchingEntityLoader")) : class$net$sf$hibernate$loader$BatchingEntityLoader));
    private final Loader nonBatchLoader;
    private final Loader batchLoader;
    private final Loader smallBatchLoader;
    private final int batchSize;
    private final int smallBatchSize;
    private final ClassPersister persister;
    private final Type idType;
    static /* synthetic */ Class class$net$sf$hibernate$loader$BatchingEntityLoader;

    public BatchingEntityLoader(ClassPersister persister, int batchSize, Loader batchLoader, int smallBatchSize, Loader smallBatchLoader, Loader nonBatchLoader) {
        this.batchLoader = batchLoader;
        this.nonBatchLoader = nonBatchLoader;
        this.batchSize = batchSize;
        this.persister = persister;
        this.smallBatchLoader = smallBatchLoader;
        this.smallBatchSize = smallBatchSize;
        this.idType = persister.getIdentifierType();
    }

    public Object load(SessionImplementor session, Serializable id, Object optionalObject) throws SQLException, HibernateException {
        List list;
        Serializable[] batch = session.getClassBatch(this.persister.getMappedClass(), id, this.batchSize);
        if (this.smallBatchSize == 1 || batch[this.smallBatchSize - 1] == null) {
            return ((UniqueEntityLoader)((Object)this.nonBatchLoader)).load(session, id, optionalObject);
        }
        if (batch[this.batchSize - 1] == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("batch loading entity (smaller batch): " + this.persister.getMappedClass().getName()));
            }
            Serializable[] smallBatch = new Serializable[this.smallBatchSize];
            System.arraycopy(batch, 0, smallBatch, 0, this.smallBatchSize);
            list = this.smallBatchLoader.loadEntityBatch(session, smallBatch, this.idType, optionalObject, id);
            log.debug((Object)"done batch load");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("batch loading entity: " + this.persister.getMappedClass().getName()));
            }
            list = this.batchLoader.loadEntityBatch(session, batch, this.idType, optionalObject, id);
            log.debug((Object)"done batch load");
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!id.equals(session.getEntityIdentifier(obj))) continue;
            return obj;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

