/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.hql;

import java.util.LinkedList;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.collection.CollectionPropertyMapping;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.hql.Parser;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.persister.PropertyMapping;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.QueryJoinFragment;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;

public class PathExpressionParser
implements Parser {
    private int dotcount;
    private String currentName;
    private String currentProperty;
    private String oneToOneOwnerName;
    private QueryJoinFragment join;
    private String[] columns;
    private String collectionName;
    private String collectionOwnerName;
    private String collectionRole;
    private final StringBuffer componentPath = new StringBuffer();
    private Type type;
    private final StringBuffer path = new StringBuffer();
    private boolean ignoreInitialJoin;
    private boolean continuation;
    private int joinType = 0;
    private boolean useThetaStyleJoin = true;
    private PropertyMapping currentPropertyMapping;
    private boolean expectingCollectionIndex;
    private LinkedList collectionElements = new LinkedList();

    void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    void setUseThetaStyleJoin(boolean useThetaStyleJoin) {
        this.useThetaStyleJoin = useThetaStyleJoin;
    }

    private void addJoin(String table, String name, String[] rhsCols) throws QueryException {
        String[] lhsCols = this.currentColumns();
        this.join.addJoin(table, name, lhsCols, rhsCols, this.joinType);
    }

    String continueFromManyToMany(Class clazz, String[] joinColumns, QueryTranslator q) throws QueryException {
        this.start(q);
        this.continuation = true;
        this.currentName = q.createNameFor(clazz);
        q.addType(this.currentName, clazz);
        Queryable classPersister = q.getPersister(clazz);
        this.join.addJoin(classPersister.getTableName(), this.currentName, joinColumns, classPersister.getIdentifierColumnNames(), this.joinType);
        this.currentPropertyMapping = classPersister;
        return this.currentName;
    }

    public void ignoreInitialJoin() {
        this.ignoreInitialJoin = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void token(String token, QueryTranslator q) throws QueryException {
        String alias;
        if (token != null) {
            this.path.append(token);
        }
        if ((alias = q.getPathAlias(this.path.toString())) != null) {
            this.reset(q);
            this.currentName = alias;
            this.currentPropertyMapping = q.getPropertyMapping(this.currentName);
            if (this.ignoreInitialJoin) return;
            JoinFragment ojf = q.getPathJoin(this.path.toString());
            this.join.addCondition(ojf.toWhereFragmentString());
            return;
        } else if (".".equals(token)) {
            ++this.dotcount;
            return;
        } else if (this.dotcount == 0) {
            if (this.continuation) return;
            if (!q.isName(token)) {
                throw new QueryException("undefined alias: " + token);
            }
            this.currentName = token;
            this.currentPropertyMapping = q.getPropertyMapping(this.currentName);
            return;
        } else if (this.dotcount == 1) {
            if (this.currentName != null) {
                this.currentProperty = token;
                return;
            } else {
                if (this.collectionName == null) throw new QueryException("unexpected");
                this.continuation = false;
            }
            return;
        } else {
            Type propertyType = this.getPropertyType();
            if (propertyType == null) {
                throw new QueryException("unresolved property: " + this.path);
            }
            if (propertyType.isComponentType()) {
                this.dereferenceComponent(token);
                return;
            } else if (propertyType.isEntityType()) {
                this.dereferenceEntity(token, (EntityType)propertyType, q);
                return;
            } else if (propertyType.isPersistentCollectionType()) {
                this.dereferenceCollection(token, ((PersistentCollectionType)propertyType).getRole(), q);
                return;
            } else {
                if (token == null) return;
                throw new QueryException("dereferenced: " + this.path);
            }
        }
    }

    private void dereferenceEntity(String propertyName, EntityType propertyType, QueryTranslator q) throws QueryException {
        boolean isNamedIdPropertyShortcut;
        String idPropertyName;
        boolean isIdShortcut = "id".equals(propertyName) && !propertyType.isUniqueKeyReference();
        try {
            idPropertyName = propertyType.getIdentifierOrUniqueKeyPropertyName(q.getFactory());
        }
        catch (MappingException me) {
            throw new QueryException(me);
        }
        boolean bl = isNamedIdPropertyShortcut = idPropertyName != null && idPropertyName.equals(propertyName);
        if (isIdShortcut || isNamedIdPropertyShortcut) {
            if (this.componentPath.length() > 0) {
                this.componentPath.append('.');
            }
            this.componentPath.append(propertyName);
        } else {
            String[] keyColNames;
            Class entityClass = propertyType.getAssociatedClass();
            String name = q.createNameFor(entityClass);
            q.addType(name, entityClass);
            Queryable memberPersister = q.getPersister(entityClass);
            try {
                keyColNames = propertyType.getReferencedColumns(q.getFactory());
            }
            catch (MappingException me) {
                throw new QueryException(me);
            }
            this.addJoin(memberPersister.getTableName(), name, keyColNames);
            if (propertyType.isOneToOne()) {
                this.oneToOneOwnerName = this.currentName;
            }
            this.currentName = name;
            this.currentProperty = propertyName;
            q.addPathAliasAndJoin(this.path.substring(0, this.path.toString().lastIndexOf(46)), name, this.join);
            this.componentPath.setLength(0);
            this.currentPropertyMapping = memberPersister;
        }
    }

    private void dereferenceComponent(String propertyName) {
        if (propertyName != null) {
            if (this.componentPath.length() > 0) {
                this.componentPath.append('.');
            }
            this.componentPath.append(propertyName);
        }
    }

    private void dereferenceCollection(String propertyName, String role, QueryTranslator q) throws QueryException {
        this.collectionRole = role;
        QueryableCollection collPersister = q.getCollectionPersister(role);
        String[] colNames = collPersister.getKeyColumnNames();
        String name = q.createNameForCollection(role);
        this.addJoin(collPersister.getTableName(), name, colNames);
        if (collPersister.hasWhere()) {
            this.join.addCondition(collPersister.getSQLWhereString(name));
        }
        this.collectionName = name;
        this.collectionOwnerName = this.currentName;
        this.currentName = name;
        this.currentProperty = propertyName;
        this.componentPath.setLength(0);
        this.currentPropertyMapping = new CollectionPropertyMapping(collPersister);
    }

    private String getPropertyPath() {
        if (this.currentProperty == null) {
            return "id";
        }
        if (this.componentPath.length() > 0) {
            return this.currentProperty + '.' + this.componentPath.toString();
        }
        return this.currentProperty;
    }

    private PropertyMapping getPropertyMapping() {
        return this.currentPropertyMapping;
    }

    private void setType() throws QueryException {
        this.type = this.currentProperty == null ? this.getPropertyMapping().getType() : this.getPropertyType();
    }

    protected Type getPropertyType() throws QueryException {
        String propertyPath = this.getPropertyPath();
        Type propertyType = this.getPropertyMapping().toType(propertyPath);
        if (propertyType == null) {
            throw new QueryException("could not resolve property type: " + propertyPath);
        }
        return propertyType;
    }

    protected String[] currentColumns() throws QueryException {
        String propertyPath = this.getPropertyPath();
        String[] propertyColumns = this.getPropertyMapping().toColumns(this.currentName, propertyPath);
        if (propertyColumns == null) {
            throw new QueryException("could not resolve property columns: " + propertyPath);
        }
        return propertyColumns;
    }

    private void reset(QueryTranslator q) {
        this.join = q.createJoinFragment(this.useThetaStyleJoin);
        this.dotcount = 0;
        this.currentName = null;
        this.currentProperty = null;
        this.collectionName = null;
        this.collectionRole = null;
        this.componentPath.setLength(0);
        this.type = null;
        this.collectionName = null;
        this.columns = null;
        this.expectingCollectionIndex = false;
        this.continuation = false;
        this.currentPropertyMapping = null;
    }

    public void start(QueryTranslator q) {
        if (!this.continuation) {
            this.reset(q);
            this.path.setLength(0);
        }
    }

    public void end(QueryTranslator q) throws QueryException {
        this.ignoreInitialJoin = false;
        Type propertyType = this.getPropertyType();
        if (propertyType != null && propertyType.isPersistentCollectionType()) {
            this.collectionRole = ((PersistentCollectionType)propertyType).getRole();
            this.collectionName = q.createNameForCollection(this.collectionRole);
            this.prepareForIndex(q);
        } else {
            this.columns = this.currentColumns();
            this.setType();
        }
        this.continuation = false;
    }

    private void prepareForIndex(QueryTranslator q) throws QueryException {
        QueryableCollection collPersister = q.getCollectionPersister(this.collectionRole);
        if (!collPersister.hasIndex()) {
            throw new QueryException("unindexed collection before []: " + this.path);
        }
        String[] indexCols = collPersister.getIndexColumnNames();
        if (indexCols.length != 1) {
            throw new QueryException("composite-index appears in []: " + this.path);
        }
        String[] keyCols = collPersister.getKeyColumnNames();
        QueryJoinFragment ojf = q.createJoinFragment(this.useThetaStyleJoin);
        ((JoinFragment)ojf).addCrossJoin(collPersister.getTableName(), this.collectionName);
        ((JoinFragment)ojf).addFromFragmentString(this.join.toFromFragmentString());
        if (collPersister.isOneToMany()) {
            Queryable persister = (Queryable)collPersister.getElementPersister();
            ((JoinFragment)ojf).addJoins(persister.fromJoinFragment(this.collectionName, true, false), persister.whereJoinFragment(this.collectionName, true, false));
        }
        if (!this.continuation) {
            this.addJoin(collPersister.getTableName(), this.collectionName, keyCols);
        }
        this.join.addCondition(this.collectionName, indexCols, " = ");
        String[] eltCols = collPersister.getElementColumnNames();
        CollectionElement elem = new CollectionElement();
        elem.elementColumns = StringHelper.qualify(this.collectionName, eltCols);
        elem.elementType = collPersister.getElementType();
        elem.isOneToMany = collPersister.isOneToMany();
        elem.alias = this.collectionName;
        elem.joinFragment = this.join;
        this.collectionElements.addLast(elem);
        this.setExpectingCollectionIndex();
        q.addCollection(this.collectionName, this.collectionRole);
        q.addJoin(this.collectionName, ojf);
    }

    public CollectionElement lastCollectionElement() {
        return (CollectionElement)this.collectionElements.removeLast();
    }

    public void setLastCollectionElementIndexValue(String value) {
        ((CollectionElement)this.collectionElements.getLast()).indexValue.append(value);
    }

    public boolean isExpectingCollectionIndex() {
        return this.expectingCollectionIndex;
    }

    protected void setExpectingCollectionIndex() throws QueryException {
        this.expectingCollectionIndex = true;
    }

    public JoinFragment getWhereJoin() {
        return this.join;
    }

    public String getWhereColumn() throws QueryException {
        if (this.columns.length != 1) {
            throw new QueryException("path expression ends in a composite value: " + this.path);
        }
        return this.columns[0];
    }

    public String[] getWhereColumns() {
        return this.columns;
    }

    public Type getWhereColumnType() {
        return this.type;
    }

    public String getName() {
        return this.currentName == null ? this.collectionName : this.currentName;
    }

    public String getCollectionSubquery() throws QueryException {
        return "select " + StringHelper.join(", ", this.currentColumns()) + " from " + this.join.toFromFragmentString().substring(2) + " where " + this.join.toWhereFragmentString().substring(5);
    }

    public boolean isCollectionValued() throws QueryException {
        return this.collectionName != null && !this.getPropertyType().isPersistentCollectionType();
    }

    public void addAssociation(QueryTranslator q) {
        q.addJoin(this.getName(), this.join);
    }

    public String addFromAssociation(QueryTranslator q) throws QueryException {
        if (this.isCollectionValued()) {
            return this.addFromCollection(q);
        }
        q.addFrom(this.currentName, this.join);
        return this.currentName;
    }

    public String addFromCollection(QueryTranslator q) throws QueryException {
        Type collectionElementType = this.getPropertyType();
        if (collectionElementType == null) {
            throw new QueryException("must specify 'elements' for collection valued property in from clause: " + this.path);
        }
        if (collectionElementType.isEntityType()) {
            String elementName;
            QueryableCollection collectionPersister = q.getCollectionPersister(this.collectionRole);
            Queryable entityPersister = (Queryable)collectionPersister.getElementPersister();
            Class clazz = entityPersister.getMappedClass();
            String[] collectionElementColumns = this.currentColumns();
            if (collectionPersister.isOneToMany()) {
                elementName = this.collectionName;
                q.decoratePropertyMapping(elementName, collectionPersister);
            } else {
                q.addCollection(this.collectionName, this.collectionRole);
                elementName = q.createNameFor(clazz);
                String[] keyColumnNames = entityPersister.getIdentifierColumnNames();
                this.join.addJoin(entityPersister.getTableName(), elementName, collectionElementColumns, keyColumnNames, this.joinType);
            }
            q.addFrom(elementName, clazz, this.join);
            this.currentPropertyMapping = new CollectionPropertyMapping(collectionPersister);
            return elementName;
        }
        q.addFromCollection(this.collectionName, this.collectionRole, this.join);
        return this.collectionName;
    }

    String getCollectionName() {
        return this.collectionName;
    }

    String getCollectionRole() {
        return this.collectionRole;
    }

    String getCollectionOwnerName() {
        return this.collectionOwnerName;
    }

    String getOneToOneOwnerName() {
        return this.oneToOneOwnerName;
    }

    String getCurrentProperty() {
        return this.currentProperty;
    }

    String getCurrentName() {
        return this.currentName;
    }

    public void fetch(QueryTranslator q, String entityName) throws QueryException {
        if (this.isCollectionValued()) {
            q.setCollectionToFetch(this.getCollectionRole(), this.getCollectionName(), this.getCollectionOwnerName(), entityName);
        } else {
            q.addEntityToFetch(entityName, this.getOneToOneOwnerName());
        }
    }

    static final class CollectionElement {
        Type elementType;
        boolean isOneToMany;
        String alias;
        String[] elementColumns;
        JoinFragment joinFragment;
        StringBuffer indexValue = new StringBuffer();

        CollectionElement() {
        }
    }
}

