/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.NewProxyConnection;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.util.ConnectionEventSupport;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public final class NewPooledConnection
implements PooledConnection {
    final Connection physicalConnection;
    final ConnectionTester connectionTester;
    final boolean autoCommitOnClose;
    final boolean forceIgnoreUnresolvedTransactions;
    final ConnectionEventSupport ces;
    GooGooStatementCache scache = null;
    Throwable invalidatingException = null;
    int connection_status = 0;
    Set uncachedActiveStatements = new HashSet();
    Map resultSetsForStatements = new HashMap();
    Set metaDataResultSets = new HashSet();
    boolean connection_error_signaled = false;
    volatile NewProxyConnection exposedProxy = null;

    public NewPooledConnection(Connection con, ConnectionTester connectionTester, boolean autoCommitOnClose, boolean forceIgnoreUnresolvedTransactions) {
        this.physicalConnection = con;
        this.connectionTester = connectionTester;
        this.autoCommitOnClose = autoCommitOnClose;
        this.forceIgnoreUnresolvedTransactions = forceIgnoreUnresolvedTransactions;
        this.ces = new ConnectionEventSupport(this);
    }

    public synchronized Connection getConnection() throws SQLException {
        try {
            if (this.exposedProxy == null) {
                this.exposedProxy = new NewProxyConnection(this.physicalConnection, this);
            } else {
                System.err.println("c3p0 -- Uh oh... getConnection() was called on a PooledConnection when it had already provided a client with a Connection that has not yet been closed. This probably indicates a bug in the connection pool!!!");
            }
            return this.exposedProxy;
        }
        catch (Exception e) {
            SQLException sqle = this.handleThrowable(e);
            throw sqle;
        }
    }

    public synchronized int getConnectionStatus() {
        return this.connection_status;
    }

    public synchronized void closeAll() throws SQLException {
        try {
            this.closeAllCachedStatements();
        }
        catch (Exception e) {
            SQLException sqle = this.handleThrowable(e);
            throw sqle;
        }
    }

    public synchronized void close() throws SQLException {
        this.close(null);
    }

    public void addConnectionEventListener(ConnectionEventListener cel) {
        this.ces.addConnectionEventListener(cel);
    }

    public void removeConnectionEventListener(ConnectionEventListener cel) {
        this.ces.removeConnectionEventListener(cel);
    }

    public synchronized void initStatementCache(GooGooStatementCache scache) {
        this.scache = scache;
    }

    public synchronized GooGooStatementCache getStatementCache() {
        return this.scache;
    }

    synchronized Object checkoutStatement(Method stmtProducingMethod, Object[] args) throws SQLException {
        return this.scache.checkoutStatement(this.physicalConnection, stmtProducingMethod, args);
    }

    synchronized void checkinStatement(Statement stmt) throws SQLException {
        this.cleanupStatementResultSets(stmt);
        this.scache.checkinStatement(stmt);
    }

    synchronized void markActiveUncachedStatement(Statement stmt) {
        this.uncachedActiveStatements.add(stmt);
    }

    synchronized void markInactiveUncachedStatement(Statement stmt) {
        this.cleanupStatementResultSets(stmt);
        this.uncachedActiveStatements.remove(stmt);
    }

    synchronized void markActiveResultSetForStatement(Statement stmt, ResultSet rs) {
        Set rss = this.resultSets(stmt, true);
        rss.add(rs);
    }

    synchronized void markInactiveResultSetForStatement(Statement stmt, ResultSet rs) {
        Set rss = this.resultSets(stmt, false);
        if (!rss.remove(rs)) {
            throw new InternalError("Marking a ResultSet inactive that we did not know was opened!");
        }
    }

    synchronized void markActiveMetaDataResultSet(ResultSet rs) {
        this.metaDataResultSets.add(rs);
    }

    synchronized void markInactiveMetaDataResultSet(ResultSet rs) {
        this.metaDataResultSets.remove(rs);
    }

    synchronized void markClosedProxyConnection(NewProxyConnection npc) throws SQLException {
        if (npc != this.exposedProxy) {
            throw new InternalError("C3P0 Error: An exposed proxy asked a PooledConnection that was not its parents to clean up its resources!");
        }
        LinkedList closeExceptions = new LinkedList();
        this.cleanupResultSets(closeExceptions);
        this.cleanupUncachedStatements(closeExceptions);
        if (closeExceptions.size() > 0) {
            System.err.println("[c3p0] The following Exceptions occurred while trying to close a Connection's stranded resources:");
            Iterator ii = closeExceptions.iterator();
            while (ii.hasNext()) {
                Throwable t = (Throwable)ii.next();
                System.err.print("[c3p0 -- conection resource close Exception]: ");
                t.printStackTrace();
            }
        }
    }

    synchronized boolean isStatementCaching() {
        return this.scache != null;
    }

    synchronized SQLException handleThrowable(Throwable t) {
        SQLException sqle = SqlUtils.toSQLException(t);
        int status = this.connectionTester.statusOnException(this.physicalConnection, sqle);
        this.updateConnectionStatus(status);
        if (status != 0) {
            System.err.print(this + " invalidated by Exception: ");
            t.printStackTrace();
            try {
                this.close(t);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new InternalError("C3P0 Error: NewPooledConnection's private close() method should suppress any Exceptions if a throwable cause is provided.");
            }
            if (!this.connection_error_signaled) {
                this.ces.fireConnectionErrorOccurred(sqle);
                this.connection_error_signaled = true;
            } else {
                System.err.println("[c3p0] Warning: PooledConnection that has already signalled a Connection error is still in use!");
                System.err.println("[c3p0] Another error has occurred [ " + t + " ] which will not be reported to listeners!");
            }
        }
        return sqle;
    }

    private void fireConnectionClosed() {
        this.exposedProxy = null;
        this.ces.fireConnectionClosed();
    }

    private void fireConnectionErrorOccurred(SQLException error) {
        this.ces.fireConnectionErrorOccurred(error);
    }

    private void close(Throwable cause) throws SQLException {
        if (this.invalidatingException == null) {
            LinkedList<SQLException> closeExceptions = new LinkedList<SQLException>();
            this.cleanupResultSets(closeExceptions);
            this.cleanupUncachedStatements(closeExceptions);
            try {
                this.closeAllCachedStatements();
            }
            catch (SQLException e) {
                closeExceptions.add(e);
            }
            try {
                this.physicalConnection.close();
            }
            catch (SQLException e) {
                closeExceptions.add(e);
            }
            if (this.connection_status == 0) {
                this.connection_status = -1;
            }
            if (cause == null) {
                this.invalidatingException = new SQLException(this + " explicitly closed!");
                NewPooledConnection.logCloseExceptions(null, closeExceptions);
                if (closeExceptions.size() > 0) {
                    throw new SQLException("Some resources failed to close properly while closing " + this);
                }
            } else {
                this.invalidatingException = cause;
                NewPooledConnection.logCloseExceptions(cause, null);
            }
        }
    }

    private void cleanupResultSets(List closeExceptions) {
        this.cleanupAllStatementResultSets(closeExceptions);
        this.cleanupMetaDataResultSets(closeExceptions);
    }

    private void cleanupMetaDataResultSets(List closeExceptions) {
        Iterator ii = this.metaDataResultSets.iterator();
        while (ii.hasNext()) {
            ResultSet rs = (ResultSet)ii.next();
            try {
                rs.close();
            }
            catch (SQLException e) {
                closeExceptions.add(e);
            }
            ii.remove();
        }
    }

    private void cleanupStatementResultSets(Statement stmt) {
        Set rss = this.resultSets(stmt, false);
        if (rss != null) {
            Iterator ii = rss.iterator();
            while (ii.hasNext()) {
                try {
                    ((ResultSet)ii.next()).close();
                }
                catch (Exception e) {
                    System.err.print("ResultSet close() failed: ");
                    e.printStackTrace();
                }
            }
        }
        this.resultSetsForStatements.remove(stmt);
    }

    private void cleanupAllStatementResultSets(List closeExceptions) {
        Iterator ii = this.resultSetsForStatements.keySet().iterator();
        while (ii.hasNext()) {
            Object stmt = ii.next();
            Set rss = (Set)this.resultSetsForStatements.get(stmt);
            Iterator jj = rss.iterator();
            while (jj.hasNext()) {
                ResultSet rs = (ResultSet)jj.next();
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    closeExceptions.add(e);
                }
            }
        }
        this.resultSetsForStatements.clear();
    }

    private void cleanupUncachedStatements(List closeExceptions) {
        Iterator ii = this.uncachedActiveStatements.iterator();
        while (ii.hasNext()) {
            Statement stmt = (Statement)ii.next();
            try {
                stmt.close();
            }
            catch (SQLException e) {
                closeExceptions.add(e);
            }
            ii.remove();
        }
    }

    private void closeAllCachedStatements() throws SQLException {
        if (this.scache != null) {
            this.scache.closeAll(this.physicalConnection);
        }
    }

    private void updateConnectionStatus(int status) {
        switch (this.connection_status) {
            case -8: {
                break;
            }
            case -1: {
                if (status != -8) break;
                this.connection_status = status;
                break;
            }
            case 0: {
                if (status == 0) break;
                this.connection_status = status;
                break;
            }
            default: {
                throw new InternalError(this + " -- Illegal Connection Status: " + this.connection_status);
            }
        }
    }

    private Set resultSets(Statement stmt, boolean create) {
        HashSet out = (HashSet)this.resultSetsForStatements.get(stmt);
        if (out == null && create) {
            out = new HashSet();
            this.resultSetsForStatements.put(stmt, out);
        }
        return out;
    }

    private static void logCloseExceptions(Throwable cause, Collection exceptions) {
        if (cause != null) {
            System.err.println("[c3p0] A PooledConnection died due to the following error!");
            cause.printStackTrace();
        }
        if (exceptions != null) {
            if (cause == null) {
                System.err.println("[c3p0] The following Exceptions occurred while trying to close a PooledConnection's resources normally.");
            } else {
                System.err.println("[c3p0] The following Exceptions occurred while trying to close a broken PooledConnection.");
            }
            Iterator ii = exceptions.iterator();
            while (ii.hasNext()) {
                Throwable t = (Throwable)ii.next();
                System.err.print("[c3p0 -- close Exception]: ");
                t.printStackTrace();
            }
        }
    }
}

