/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.type.MutableType;
import net.sf.hibernate.type.VersionType;

public class CalendarType
extends MutableType
implements VersionType {
    static /* synthetic */ Class class$java$util$Calendar;

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        Timestamp ts = rs.getTimestamp(name);
        if (ts != null) {
            GregorianCalendar cal = new GregorianCalendar();
            if (Environment.jvmHasTimestampBug()) {
                cal.setTime(new Date(ts.getTime() + (long)(ts.getNanos() / 1000000)));
            } else {
                cal.setTime(ts);
            }
            return cal;
        }
        return null;
    }

    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        st.setTimestamp(index, new Timestamp(((Calendar)value).getTime().getTime()));
    }

    public int sqlType() {
        return 93;
    }

    public String toString(Object value) throws HibernateException {
        return Hibernate.TIMESTAMP.toString(((Calendar)value).getTime());
    }

    public Object fromStringValue(String xml) throws HibernateException {
        GregorianCalendar result = new GregorianCalendar();
        result.setTime((Date)Hibernate.TIMESTAMP.fromString(xml));
        return result;
    }

    public Object deepCopyNotNull(Object value) throws HibernateException {
        return ((Calendar)value).clone();
    }

    public Class getReturnedClass() {
        return class$java$util$Calendar == null ? (class$java$util$Calendar = CalendarType.class$("java.util.Calendar")) : class$java$util$Calendar;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Calendar calendar1 = (Calendar)x;
        Calendar calendar2 = (Calendar)y;
        return calendar1.get(14) == calendar2.get(14) && calendar1.get(13) == calendar2.get(13) && calendar1.get(12) == calendar2.get(12) && calendar1.get(11) == calendar2.get(11) && calendar1.get(5) == calendar2.get(5) && calendar1.get(2) == calendar2.get(2) && calendar1.get(1) == calendar2.get(1);
    }

    public String getName() {
        return "calendar";
    }

    public Object next(Object current) {
        return this.seed();
    }

    public Object seed() {
        return Calendar.getInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

