/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockingCache {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$constructs$blocking$BlockingCache == null ? (class$net$sf$ehcache$constructs$blocking$BlockingCache = BlockingCache.class$("net.sf.ehcache.constructs.blocking.BlockingCache")) : class$net$sf$ehcache$constructs$blocking$BlockingCache).getName());
    private final Cache cache;
    private final Map locks = new HashMap();
    static /* synthetic */ Class class$net$sf$ehcache$constructs$blocking$BlockingCache;

    public BlockingCache(String name) throws CacheException {
        CacheManager manager = null;
        try {
            manager = CacheManager.create();
        }
        catch (CacheException e) {
            throw new CacheException("CacheManager cannot be created");
        }
        this.cache = manager.getCache(name);
        if (this.cache == null || !this.cache.getName().equals(name)) {
            throw new CacheException("Cache " + name + " cannot be retrieved. Please check ehcache.xml");
        }
    }

    protected Cache getCache() {
        return this.cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Serializable get(Serializable key) throws CacheException {
        Mutex lock = this.checkLockExistsForKey(key);
        try {
            lock.acquire();
            Element element = this.cache.get(key);
            if (element != null) {
                lock.release();
                return element.getValue();
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted");
        }
        catch (CacheException e) {
            throw new CacheException("EHCache exception");
        }
    }

    private synchronized Mutex checkLockExistsForKey(Serializable key) {
        Mutex lock = (Mutex)this.locks.get(key);
        if (lock == null) {
            lock = new Mutex();
            this.locks.put(key, lock);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Serializable key, Serializable value) {
        Mutex lock = this.checkLockExistsForKey(key);
        try {
            if (value != null) {
                Element element = new Element(key, value);
                this.cache.put(element);
            } else {
                this.cache.remove(key);
            }
        }
        finally {
            lock.release();
        }
    }

    public Collection getKeys() {
        return this.cache.getKeys();
    }

    public void clear() throws CacheException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cache " + this.cache.getName() + ": removing all entries"));
        }
        try {
            this.cache.removeAll();
        }
        catch (IOException e) {
            throw new CacheException("Failure clearing cache");
        }
    }

    public synchronized String liveness() {
        return this.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

