<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <title>Ryzykowne prace - Wyszukiwanie</title>
  <link rel="stylesheet" type="text/css" href="style.css" />
</head>
<body>
  <img src="riskyjobs_title.gif" alt="Ryzykowne prace" />
  <img src="riskyjobs_fireman.jpg" alt="Ryzykowne prace" style="float:right" />
  <h3>Ryzykowne prace - Wyniki wyszukiwania</h3>

<?php
  // Ta funkcja tworzy zapytanie na podstawie szukanych słów i numeru metody sortowania.
  function build_query($user_search, $sort) {
    $search_query = "SELECT * FROM riskyjobs";

    // Zapisywanie szukanych słów w tablicy.
    $clean_search = str_replace(',', ' ', $user_search);
    $search_words = explode(' ', $clean_search);
    $final_search_words = array();
    if (count($search_words) > 0) {
      foreach ($search_words as $word) {
        if (!empty($word)) {
          $final_search_words[] = $word;
        }
      }
    }

    // Generowanie klauzuli WHERE przy użyciu wszystkich szukanych słów.
    $where_list = array();
    if (count($final_search_words) > 0) {
      foreach($final_search_words as $word) {
        $where_list[] = "description LIKE '%$word%'";
      }
    }
    $where_clause = implode(' OR ', $where_list);

    // Dodawanie klauzuli WHERE do zapytania.
    if (!empty($where_clause)) {
      $search_query .= " WHERE $where_clause";
    }

    // Porządkowanie wyników na podstawie numeru metody sortowania.
    switch ($sort) {
    // Rosnąco według stanowisk.
    case 1:
      $search_query .= " ORDER BY title";
      break;
    // Malejąco według stanowisk.
    case 2:
      $search_query .= " ORDER BY title DESC";
      break;
    // Rosnąco według województw.
    case 3:
      $search_query .= " ORDER BY state";
      break;
    // Malejąco według województw.
    case 4:
      $search_query .= " ORDER BY state DESC";
      break;
    // Rosnąco według dat dodania (najstarsze na początku).
    case 5:
      $search_query .= " ORDER BY date_posted";
      break;
    // Malejąco według dat dodania (najnowsze na początku).
    case 6:
      $search_query .= " ORDER BY date_posted DESC";
      break;
    default:
      // Nie określono metody sortowania, dlatego funkcja nie porządkuje danych.
    }

    return $search_query;
  }

  // Ta funkcja tworzy nagłówki - odnośniki na podstawie numeru metody sortowania.
  function generate_sort_links($user_search, $sort) {
    $sort_links = '';

    switch ($sort) {
    case 1:
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=2">Stanowisko</a></td><td>Opis</td>';
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=3">Województwo</a></td>';
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=5">Data dodania</a></td>';
      break;
    case 3:
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=1">Stanowisko</a></td><td>Opis</td>';
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=4">Województwo</a></td>';
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=3">Data dodania</a></td>';
      break;
    case 5:
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=1">Stanowisko</a></td><td>Opis</td>';
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=3">Województwo</a></td>';
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=6">Data dodania</a></td>';
      break;
    default:
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=1">Stanowisko</a></td><td>Opis</td>';
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=3">Województwo</a></td>';
      $sort_links .= '<td><a href = "' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=5">Data dodania</a></td>';
    }

    return $sort_links;
  }

  // Ta funkcja tworzy odnośniki nawigacyjne na podstawie numeru aktualnej strony i liczby wszystkich stron.
  function generate_page_links($user_search, $sort, $cur_page, $num_pages) {
    $page_links = '';

    // Jeśli nie jest to pierwsza grupa wyników, należy wygenerować odnośnik do poprzedniej strony.
    if ($cur_page > 1) {
      $page_links .= '<a href="' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=' . $sort . '&page=' . ($cur_page - 1) . '"><-</a> ';
    }
    else {
      $page_links .= '<- ';
    }

    // Przejście w pętli po stronach i wygenerowanie odnośników z numerami. 
    for ($i = 1; $i <= $num_pages; $i++) {
      if ($cur_page == $i) {
        $page_links .= ' ' . $i;
      }
      else {
        $page_links .= ' <a href="' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=' . $sort . '&page=' . $i . '"> ' . $i . '</a>';
      }
    }

    // Jeśli nie jest to ostatnia grupa wyników, należy wygenerować odnośnik do następnej strony.
    if ($cur_page < $num_pages) {
      $page_links .= ' <a href="' . $_SERVER['PHP_SELF'] . '?usersearch=' . $user_search . '&sort=' . $sort . '&page=' . ($cur_page + 1) . '">-></a>';
    }
    else {
      $page_links .= ' ->';
    }

    return $page_links;
  }

  // Pobieranie metody sortowania i szukanych słów z adresu URL (z żądania GET).
  $sort = $_GET['sort'];
  $user_search = $_GET['usersearch'];

  // Obliczanie wartości zmiennych na potrzeby stronicowania.
  $cur_page = isset($_GET['page']) ? $_GET['page'] : 1;
  $results_per_page = 5;  // Liczba wyników na stronę.
  $skip = (($cur_page - 1) * $results_per_page);

  // Rozpoczęcie generowania tabeli z wynikami.
  echo '<table border="0" cellpadding="2">';

  // Generowanie nagłówków - odnośników.
  echo '<tr class="heading">';
  echo generate_sort_links($user_search, $sort);
  echo '</tr>';

  // Łączenie się z bazą danych.
  require_once('connectvars.php');
  $dbc = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

  // Sprawdzanie liczby wszystkich wyników.
  $query = build_query($user_search, $sort);
  $result = mysqli_query($dbc, $query);
  $total = mysqli_num_rows($result);
  $num_pages = ceil($total / $results_per_page);

  // Drugie zapytanie, które pobiera tylko podzbiór wyników.
  $query =  $query . " LIMIT $skip, $results_per_page";
  
  $result = mysqli_query($dbc, $query);
  while ($row = mysqli_fetch_array($result)) {
    echo '<tr class="results">';
    echo '<td valign="top" width="20%">' . $row['title'] . '</td>';
    echo '<td valign="top" width="50%">' . substr($row['description'], 0, 100) . '...</td>';
    echo '<td valign="top" width="10%">' . $row['state'] . '</td>';
    echo '<td valign="top" width="20%">' . substr($row['date_posted'], 0, 10) . '</td>';
    echo '</tr>';
  } 
  echo '</table>';

  // Generowanie odnośników nawigacyjnych, jeśli wyniki zajmują więcej niż jedną stronę.
  if ($num_pages > 1) {
    echo generate_page_links($user_search, $sort, $cur_page, $num_pages);
  }

  mysqli_close($dbc);
?>

</body>
</html>
