
import java.io.*;
import java.util.*;

public class SubwayTester
{
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Sposb wywoania: SubwayTester [stacjaPocztkowa] [stacjaKocowa]");
            System.exit(-1);
        }
        try {
            SubwayLoader loader = new SubwayLoader();
            Subway objectville = loader.loadFromFile(new File("MetroWObiektowie.txt"));
            
            if (!objectville.hasStation(args[0])) {
                System.err.println("Stacja " + args[0] + " nie naley do sieci metra w Obiektowie.");
                System.exit(-1);
            } else if (!objectville.hasStation(args[1])) {
                System.err.println("Stacja " + args[1] + " nie naley do sieci metra w Obiektowie.");
                System.exit(-1);
            }
            
            List route = objectville.getDirections(args[0], args[1]);
            SubwayPrinter printer = new SubwayPrinter(System.out);
            printer.printDirections(route);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}
