import java.rmi.*;
import java.util.*;
import java.rmi.server.*;


public class SerwerUslugImpl extends UnicastRemoteObject implements SerwerUslug  {

  HashMap listaUslug;

  public SerwerUslugImpl() throws RemoteException {
    // uruchomienie i konfiguracja usug 
    konfigurujUslugi();
  }

  private void konfigurujUslugi() {
    listaUslug = new HashMap();
    listaUslug.put("Usuga gry w koci", new GraWKosciUsluga());  
    listaUslug.put("Usuga dnia tygodnia", new DzienTygodniaUsluga());  
    listaUslug.put("Usuga wizualizacji muzyki", new MiniMuzykaUsluga());   
  }

  public Object[] pobierzListeUslug() {
    System.out.println("zdalne");
    return listaUslug.keySet().toArray();
  }

  public Usluga pobierzUsluge(Object kluczUsl) throws RemoteException {        
    Usluga usluga = (Usluga) listaUslug.get(kluczUsl);       
    return usluga;
  }

  public static void main (String[] args) {
    try {
      Naming.rebind("SerwerUslug", new SerwerUslugImpl());
    } catch(Exception ex) { }
    System.out.println("Zdalna usuga uruchomiona");
  }
}