window.onload = initPage;

function initPage() {
  // wyszukaj miniatury na stronie
  var thumbs = 
    document.getElementById("thumbnailPane").getElementsByTagName("img");

  // prypisz procedurę do każdego obrazka
  for (var i = 0; i < thumbs.length; i++) {
    var image = thumbs[i];
    
    // utwórz funkcję onclick
    image.onclick = function() {
      // find the image name
      var detailURL = 'images/' + this.title + '-detail.jpg';
      document.getElementById("itemDetail").src = detailURL;
      getDetails(this.title);
    }
  }
}

function getDetails(itemName) {
  request = createRequest();
  if (request == null) {
    alert("Nie można utworzyć żąania.");
    return;
  }
  // Wersja dla skryptu serwerowego zwracającego CSV
  var url= "getDetailsCSV.php?ImageID=" + escape(itemName);
  request.open("GET", url, true);
  request.onreadystatechange = displayDetails;
  request.send(null);
}

function displayDetails() {
  if (request.readyState == 4) {
    if (request.status == 200) {
      var detailDiv = document.getElementById("description");

      // Usuń dotychczasowe informacje (jeżeli istnieją)
      for (var i=detailDiv.childNodes.length; i>0; i--) {
        detailDiv.removeChild(detailDiv.childNodes[i-1]);
      }

      // Dodaj nowe informacje o przedmiocie.
      var response = request.responseText;
      var itemDetails = response.split(";");
      var descriptionP = document.createElement("p");
      descriptionP.appendChild(
        document.createTextNode("Opis: " + itemDetails[1]));
      detailDiv.appendChild(descriptionP);
      var priceP = document.createElement("p");
      priceP.appendChild(
        document.createTextNode("Cena: " + itemDetails[2] + " zł"));
      detailDiv.appendChild(priceP);
      var list = document.createElement("ul");
      for (var i=3; i<itemDetails.length; i++) {
        var li = document.createElement("li");
        var a = document.createElement("a");
        a.setAttribute("href", itemDetails[i]);
        a.appendChild(document.createTextNode(itemDetails[i]));
        li.appendChild(a);
        list.appendChild(li);
      }
      detailDiv.appendChild(list);
    }  
  }
}
