#include <libopencm3/stm32/rcc.h>
#include <libopencm3/stm32/gpio.h>
#include <libopencm3/stm32/f1/spi.h>

#include <libLHP_SPI.h>

void setup_SPI1_GPIO(){
  gpio_set_mode(GPIOA,
                GPIO_MODE_OUTPUT_50_MHZ,
                GPIO_CNF_OUTPUT_ALTFN_PUSHPULL,
                GPIO_SPI1_NSS | GPIO_SPI1_SCK | GPIO_SPI1_MOSI
                );
  gpio_set_mode(GPIOA,
                GPIO_MODE_INPUT,
                GPIO_CNF_INPUT_FLOAT,
                GPIO_SPI1_MISO);
}

void setup_SPI2_GPIO(){
  gpio_set_mode(GPIOB,
                GPIO_MODE_OUTPUT_50_MHZ,
                GPIO_CNF_OUTPUT_ALTFN_PUSHPULL,
                GPIO_SPI2_NSS | GPIO_SPI2_SCK |
                GPIO_SPI2_MOSI
                );
  gpio_set_mode(GPIOB,
                GPIO_MODE_INPUT,
                GPIO_CNF_INPUT_FLOAT,
                GPIO_SPI2_MISO);

}
void setup_SPI1(){
   rcc_periph_clock_disable(RCC_SPI1);
   rcc_periph_clock_enable(RCC_SPI1);
   rcc_periph_clock_enable(RCC_GPIOA);
   setup_SPI1_GPIO();
   spi_reset(SPI1);
   spi_disable(SPI1);

}

void setup_SPI2(){
  rcc_periph_clock_disable(RCC_SPI2);
  rcc_periph_clock_enable(RCC_SPI2);
  rcc_periph_clock_enable(RCC_GPIOB);
  setup_SPI2_GPIO();
  spi_reset(SPI2);
  spi_disable(SPI2);
}
