#ifndef __LHP_D1W_H
#define __LHP_D1W_H

#define D1W_READ_ROM         0x33
#define D1W_SEARCH_ROM       0xf0
#define D1W_SKIP_ROM         0xcc
#define D1W_MATCH_ROM        0x55

void D1W_setup(uint8_t num,uint32_t gpio_port, uint8_t gpio_num);
void D1W_runfor_us(uint8_t num,uint16_t runfor);
void D1W_blockfor_us(uint8_t num,uint16_t runfor);
void D1W_blockfor_ms(uint8_t num,uint16_t runfor);
uint8_t D1W_detect_presence(uint8_t num);
void D1W_write8 (uint8_t num,uint8_t data);
void D1W_write16(uint8_t num,uint16_t data);
void D1W_write32(uint8_t num,uint32_t data);
void D1W_write64(uint8_t num,uint64_t data);
uint8_t  D1W_read8 (uint8_t num);
uint16_t D1W_read16(uint8_t num);
uint32_t D1W_read32(uint8_t num);
uint64_t D1W_read64(uint8_t num);
void     D1W_read_rom(uint8_t num,uint64_t * rom);
uint8_t  D1W_getcrc(uint8_t* data,uint8_t len);
uint8_t D1W_search_rom(uint8_t num);
uint64_t D1W_get_rom(uint8_t id);
uint8_t D1W_matchrom(uint8_t id,uint64_t rom);
uint8_t D1W_matchrom_id(uint8_t num,uint8_t id);
#endif
