/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.testpolozenia;

import java.util.List;

import android.app.Activity;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.widget.TextView;

public class TestPolozenia extends Activity implements
    LocationListener {
                 
    private static final String[] A = { "nieprawidowa" , "niedostpna" , "dokadna" , 
        "zgrubna" };
    private static final String[] P = { "nieprawidowa" , "niedostpna" , "niska" , 
        "rednia" , "wysoka" };
    private static final String[] S = { "nieczynny" ,
        "tymczasowo niedostpny" , "dostpny" };
    
    private LocationManager menedzer;
    private TextView wyjscie;
    private String najlepszy;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        menedzer = (LocationManager) getSystemService(LOCATION_SERVICE);
        wyjscie = (TextView) findViewById(R.id.wyjscie);

        dziennik("Dostawcy pooenia:" );
        wyrzucDostawcow();

        Criteria kryteria = new Criteria();
        najlepszy = menedzer.getBestProvider(kryteria, true);
        dziennik("\nNajlepszym dostawc jest: " + najlepszy);

        dziennik("\nLokalizacja (poczwszy od ostatniej znanej):" );
        Location lokacja = menedzer.getLastKnownLocation(najlepszy);
        wyrzucLokacje(lokacja);
    }
                
    @Override
    protected void onResume() {
        super.onResume();
        // Uruchamia aktualizacje (dokumentacja zaleca opnienie >= 60000 ms)
        menedzer.requestLocationUpdates(najlepszy, 15000, 1, this);
    }

    @Override
    protected void onPause() {
        super.onPause();
        // Zatrzymuje aktualizacje podczas wstrzymania aplikacji
        menedzer.removeUpdates(this);
    }
                
    public void onLocationChanged(Location lokacja) {
        wyrzucLokacje(lokacja);
    }

    public void onProviderDisabled(String dostawca) {
        dziennik("\nWyczony dostawca: " + dostawca);
    }

    public void onProviderEnabled(String dostawca) {
        dziennik("\nWczony dostawca: " + dostawca);
    }

    public void onStatusChanged(String dostawca, int status,
            Bundle dodatki) {
        dziennik("\nZmiana stanu dostawcy: " + dostawca + ", status="
                + S[status] + ", dodatkowe=" + dodatki);
    }
                
    /** Wywietla cig znakw w oknie wynikowym */
    private void dziennik(String string) {
        wyjscie.append(string + "\n" );
    }

    /** Wywietla informajce od wszystkich dostawcw pooenia */
    private void wyrzucDostawcow() {
        List<String> dostawcy = menedzer.getAllProviders();
        for (String dostawca : dostawcy) {
            wyrzucDostawce(dostawca);
        }
    }

    /** Wywietla informacje od jednego dostawcy pooenia */
    private void wyrzucDostawce(String dostawca) {
        LocationProvider info = menedzer.getProvider(dostawca);
        StringBuilder konstruktor = new StringBuilder();
        konstruktor.append("LocationProvider[" )
            .append("nazwa=" )
            .append(info.getName())
            .append(",uruchomiony=" )
            .append(menedzer.isProviderEnabled(dostawca))
            .append(",Dokadno (getAccuracy)=" )
            .append(A[info.getAccuracy() + 1])
            .append(",Koszty energetyczne (getPowerRequirement)=" )
            .append(P[info.getPowerRequirement() + 1])
            .append(",Koszty pienine (hasMonetaryCost)=" )
            .append(info.hasMonetaryCost())
            .append(",Wiea nadawcza (requiresCell)=" )
            .append(info.requiresCell())
            .append(",Sie (requiresNetwork)=" )
            .append(info.requiresNetwork())
            .append(",Satelita (requiresSatellite)=" )
            .append(info.requiresSatellite())
            .append(",Obsuga wysokoci (supportsAltitude)=" )
            .append(info.supportsAltitude())
            .append(",Obsuga pelengu (supportsBearing)=" )
            .append(info.supportsBearing())
            .append(",Obsuga prdkoci (supportsSpeed)=" )
            .append(info.supportsSpeed())
            .append("]" );
        dziennik(konstruktor.toString());
    }

    /** Opisuje dan lokalizacj, moe przyj warto null */
    private void wyrzucLokacje(Location lokacja) {
        if (lokacja == null)
            dziennik("\nLokacja[nieznana]" );
        else
            dziennik("\n" + lokacja.toString());
    }
}
