/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/

package org.przyklad.tapeta;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLUtils;

class SzescianGL {
    private final IntBuffer mBuforWierzcholka;
                
    private final IntBuffer mBuforTekstury;
                
    public SzescianGL() {
        int jeden = 65536;
        int pol = jeden / 2;
        int wierzcholki[] = {
            // PRZD
            -pol, -pol, pol, pol, -pol, pol,
            -pol, pol, pol, pol, pol, pol,
            // TY
            -pol, -pol, -pol, -pol, pol, -pol,
            pol, -pol, -pol, pol, pol, -pol,
            // LEWO
            -pol, -pol, pol, -pol, pol, pol,
            -pol, -pol, -pol, -pol, pol, -pol,
            // PRAWO
            pol, -pol, -pol, pol, pol, -pol,
            pol, -pol, pol, pol, pol, pol,
            // SZCZYT
            -pol, pol, pol, pol, pol, pol,
            -pol, pol, -pol, pol, pol, -pol,
            // SPD
            -pol, -pol, pol, -pol, -pol, -pol,
            pol, -pol, pol, pol, -pol, -pol, };
                     
        int wspolrzTekst[] = {
            // PRZD
            0, jeden, jeden, jeden, 0, 0, jeden, 0,
            // TY
            jeden, jeden, jeden, 0, 0, jeden, 0, 0,
            // LEWO
            jeden, jeden, jeden, 0, 0, jeden, 0, 0,
            // PRAWO
            jeden, jeden, jeden, 0, 0, jeden, 0, 0,
            // SZCZYT
            jeden, 0, 0, 0, jeden, jeden, 0, jeden,
            // SPD
            0, 0, 0, jeden, jeden, 0, jeden, jeden, };
  
        // Bufory przekazywane funkcjom gl*Pointer() musz by
        // bezporednie, tzn. musz zota umieszczone natywnym stosie,
        // do ktrego nie moe ich przenie odzyskiwacz pamici.
        //
        // Bufory zawierajce wielobajtowe typy danych (np. short, int,
        // float) musz posiada natywny porzdek bajtw.
        ByteBuffer vbb = ByteBuffer.allocateDirect(wierzcholki.length * 4);
        vbb.order(ByteOrder.nativeOrder());
        mBuforWierzcholka = vbb.asIntBuffer();
        mBuforWierzcholka.put(wierzcholki);
        mBuforWierzcholka.position(0);
                                         
        // ...
        ByteBuffer tbb = ByteBuffer.allocateDirect(wspolrzTekst.length * 4);
        tbb.order(ByteOrder.nativeOrder());
        mBuforTekstury = tbb.asIntBuffer();
        mBuforTekstury.put(wspolrzTekst);
        mBuforTekstury.position(0);             
    }

    public void draw(GL10 gl) {
        gl.glVertexPointer(3, GL10.GL_FIXED, 0, mBuforWierzcholka);
                     
        gl.glTexCoordPointer(2, GL10.GL_FIXED, 0, mBuforTekstury);

        gl.glColor4f(1, 1, 1, 1);
        gl.glNormal3f(0, 0, 1);
        gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 0, 4);
        gl.glNormal3f(0, 0, -1);
        gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 4, 4);

        gl.glColor4f(1, 1, 1, 1);
        gl.glNormal3f(-1, 0, 0);
        gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 8, 4);
        gl.glNormal3f(1, 0, 0);
        gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 12, 4);

        gl.glColor4f(1, 1, 1, 1);
        gl.glNormal3f(0, 1, 0);
        gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 16, 4);
        gl.glNormal3f(0, -1, 0);
        gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 20, 4);
    }
                 
    static void loadTexture(GL10 gl, Context kontekst, int zasob) {
        Bitmap bmp = BitmapFactory.decodeResource(
            kontekst.getResources(), zasob);
        GLUtils.texImage2D(GL10.GL_TEXTURE_2D, 0, bmp, 0);
        gl.glTexParameterx(GL10.GL_TEXTURE_2D,
            GL10.GL_TEXTURE_MIN_FILTER, GL10.GL_LINEAR);
        gl.glTexParameterx(GL10.GL_TEXTURE_2D,
            GL10.GL_TEXTURE_MAG_FILTER, GL10.GL_LINEAR);
        bmp.recycle();
    }
}