/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.testczujnika;

import java.util.List;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.widget.TextView;

public class TestCzujnika extends Activity implements SensorEventListener {
   

   
   
   private SensorManager menedzer;
   
   private TextView wyjscie;
   
   private List<Sensor> listaCzujnik;
   

   @Override
   public void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      setContentView(R.layout.main);

      
      // ...
      menedzer = (SensorManager) getSystemService(SENSOR_SERVICE);
      
      wyjscie = (TextView) findViewById(R.id.wyjscie);
   }
   

   
   @Override
   protected void onResume() {
      super.onResume();
      
      // Rozpoczyna aktualizowanie danych z przynajmniej jednego czujnika
      listaCzujnik = menedzer.getSensorList(Sensor.TYPE_ALL);
      for (Sensor czujnik : listaCzujnik) {
         menedzer.registerListener(this, czujnik,
                 SensorManager.SENSOR_DELAY_NORMAL);
      }
      
   }

   @Override
   protected void onPause() {
      super.onPause();
      
      // W trakcie wstrzymania aplikacji zatrzymuje pobieranie aktualizowanych danych w celu
      // zaoszczdzenia energii
      menedzer.unregisterListener(this);
      
   }
   

   public void onAccuracyChanged(Sensor czujnik, int dokladnosc) {
      // Do zrobienia: automatycznie wygenerowany zalek metody
   }

   
   public void onSensorChanged(SensorEvent zdarzenie) {
      
      StringBuilder konstruktor = new StringBuilder();
      konstruktor.append("--- CZUJNIK ---");
      konstruktor.append("\nNazwa: ");
      Sensor czujnik = zdarzenie.sensor;
      konstruktor.append(czujnik.getName());
      konstruktor.append("\nTyp: ");
      konstruktor.append(czujnik.getType());
      konstruktor.append("\nProducent: ");
      konstruktor.append(czujnik.getVendor());
      konstruktor.append("\nWersja: ");
      konstruktor.append(czujnik.getVersion());
      konstruktor.append("\nMaksymalny zasig: ");
      konstruktor.append(czujnik.getMaximumRange());
      konstruktor.append("\nZasilanie: ");
      konstruktor.append(czujnik.getPower());
      konstruktor.append("\nRozdzielczo: ");
      konstruktor.append(czujnik.getResolution());

      konstruktor.append("\n\n--- ZDARZENIE ---");
      konstruktor.append("\nDokadno: ");
      konstruktor.append(zdarzenie.accuracy);
      konstruktor.append("\nZnacznik czasowy: ");
      konstruktor.append(zdarzenie.timestamp);
      konstruktor.append("\nWartoci:\n");
      
      for (int i = 0; i < zdarzenie.values.length; i++) {
         // ...
         
         konstruktor.append("   [");
         konstruktor.append(i);
         konstruktor.append("] = ");
         konstruktor.append(zdarzenie.values[i]);
         konstruktor.append("\n");
         
      }
      
      wyjscie.setText(konstruktor);
      
   }
   

   
}
