#!/usr/bin/env python3
import time
import sys
import serial
import argparse
from serial.threaded import LineReader, ReaderThread

parser = argparse.ArgumentParser(description='Odbiornik radiowy LoRa')
parser.add_argument('port', help='Deskryptor portu szeregowego')
args = parser.parse_args()

class PrintLines(LineReader):
   def connection_made(self, transport):
      print('Nawiązane połączenie szeregowe')
      self.transport = transport
      self.send_cmd('mac pause')
      self.send_cmd('radio set wdt 0')
      self.send_cmd('radio set crc off')
      self.send_cmd('radio set sf sf7')
      self.send_cmd('radio rx 0')
   
   def handle_line(self, data):
      if data == 'ok' or data == 'busy':
         return
      if data == 'radio_err':
         self.send_cmd('radio rx 0')
         return
      if 'radio_rx' in data:
         print(bytes.fromhex(data[10:]).decode('utf-8', errors='ignore'))
      else:
         print(data)
      time.sleep(.1)
      self.send_cmd('radio rx 0')
   
   def connection_lost(self, exc):
      if exc:
         print(exc)
      print('Port zamknięty')
   
   def send_cmd(self, cmd, delay=.5):
      self.transport.write(('%s\r\n' % cmd).encode('UTF-8'))
      time.sleep(delay)

ser = serial.Serial(args.port, baudrate=57600)
with ReaderThread(ser, PrintLines) as protocol:
   while(1):
      pass