#include "ncrack.h"
#include "nsock.h"
#include "Service.h"
#include "modules.h"

#define MQTT_TIMEOUT 20000
extern void ncrack_read_handler(nsock_pool nsp, nsock_event nse, void *mydata);
extern void ncrack_write_handler(nsock_pool nsp, nsock_event nse, void *mydata);
extern void ncrack_module_end(nsock_pool nsp, void *mydata);

static int mqtt_loop_read(nsock_pool nsp, Connection *con);
enum states { MQTT_INIT, MQTT_FINI };

struct connect_cmd {
  uint8_t message_type;    /* Wartość 1 dla pakietu CONNECT */
  uint8_t msg_len;         /* Długość pozostałej części pakietu */
  uint16_t prot_name_len;  /* Wartość 4 dla ciągu "MQTT" */
  u_char protocol[4];      /* Ciąg "MQTT" */
  uint8_t version;         /* Wartość 4 dla wersji 3.1.1 protokołu MQTT */
  uint8_t flags;           /* Wartość 0xc2 oznaczająca flagi: nazwa użytkownika, hasło, czysta sesja */
  uint16_t keep_alive;     /* 60 sekund */
  uint16_t client_id_len;  /* Wartość 6 dla identyfikatora "Ncrack" */
  u_char client_id[6];     /* Identyfikator "Ncrack" */
  uint16_t username_len;   /* Długość nazwy użytkownika */
    /* Pozostała część pakietu, którą będziemy w buforze zapisywać dynamicznie:
     * username (zmienna długość),
     * password_length (uint16_t)
     * password (zmienna długość)
     */
  connect_cmd() {  /* Konstruktor inicjujący strukturę poniższymi wartościami */
    message_type = 0x10;
    prot_name_len = htons(4);
    memcpy(protocol, "MQTT", 4);
    version = 0x04;
    flags = 0xc2;
    keep_alive = htons(60);
    client_id_len = htons(6);
    memcpy(client_id, "Ncrack", 6);
  }
} __attribute__((__packed__)) connect_cmd;

struct ack {
  uint8_t message_type;
  uint8_t msg_len;
  uint8_t flags;
  uint8_t ret_code;
} __attribute__((__packed__)) ack;

static int
mqtt_loop_read(nsock_pool nsp, Connection *con)
{
  struct ack *p;
  if (con->inbuf == NULL || con->inbuf->get_len() < 4) {
    nsock_read(nsp, con->niod, ncrack_read_handler, MQTT_TIMEOUT, con);
    return -1;
  }
  p = (struct ack *)((char *)con->inbuf->get_dataptr());
  if (p->message_type != 0x20) /* Przerywamy przetwarzanie, jeżeli nie jest to pakiet CONNACK */
    return -2;

  if (p->ret_code == 0) /* Zwracamy wartość 0 tylko wtedy, gdy kod odpowiedzi jest równy 0 */
    return 0;
  return -2;
}

void 
ncrack_mqtt(nsock_pool nsp, Connection *con)
{
  nsock_iod nsi = con->niod;
    struct connect_cmd cmd;
    uint16_t pass_len;

  switch (con->state)
  {
    case MQTT_INIT:
      con->state = MQTT_FINI;

      delete con->inbuf;
      con->inbuf = NULL;
      if (con->outbuf)
        delete con->outbuf;
      con->outbuf = new Buf();

      /* Długość komunikatu jest to suma wielkości struktury, nazwy użytkownika
       * i hasła pomniejszona o 2, ponieważ pierwsze dwa bajty nie są wliczane.
       */
      cmd.msg_len = sizeof(connect_cmd) + strlen(con->user) + strlen(con->pass) +
                      sizeof(pass_len) - 2;
      cmd.username_len = htons(strlen(con->user));
      pass_len = htons(strlen(con->pass));

      con->outbuf->append(&cmd, sizeof(cmd));
      con->outbuf->snprintf(strlen(con->user), "%s", con->user);
      con->outbuf->append(&pass_len, sizeof(pass_len));
      con->outbuf->snprintf(strlen(con->pass), "%s", con->pass);

      nsock_write(nsp, nsi, ncrack_write_handler, MQTT_TIMEOUT, con,
            (const char *)con->outbuf->get_dataptr(), con->outbuf->get_len());
      break;
   case MQTT_FINI:
     if (mqtt_loop_read(nsp, con) == -1)
       break;
     else if (mqtt_loop_read(nsp, con) == 0)
       con->auth_success = true;
     con->state = MQTT_INIT;
     delete con->inbuf;
     con->inbuf = NULL;
     return ncrack_module_end(nsp, con);
  }
}