#define TITLE    "DoxRoute: Userspace IP Router"
#define VERSION  "0.1"
#define CODERS   "Copyright (C) 2001 Dan Kaminsky (dan@doxpara.com)"
#define CODENAME "Bender"
#define GIANT    "Mark Grimes(obecian@packetninja.net)"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <libnet.h>
#include <pcap.h>

#ifndef IPV4_ADDR_LEN
#define IPV4_ADDR_LEN 4
#endif	/*  */
void usage ();
void print_ip (FILE * stream, u_char * ip);
void print_mac (FILE * stream, u_char * mac);
int 
main (int argc, char **argv) 
{
  int opt;
  extern char *optarg;
  extern int opterr;
  pcap_t * pcap;		/* Deskryptor pliku PCAP */
  u_char * packet;		/* Nasz nowo przechwycony pakiet */
  struct pcap_pkthdr pkthdr;	/* Metadane pakietu--czas otrzymania, rozmiar */
  struct bpf_program fp;	/* Struktura przechowujaca filtr pakietow jadra */
  char pfprogram[255];		/* Bufor dla nieskompilowanego filtru pakietw */
  char dev[255];		/* Nazwa urzadzenia */
  int immediate = 1;		/* Znacznik pobierania pakietow z maks. szybkoscia */
  int promisc = 1;		/* Znacznik przechwytywania wszystkich pakietow */
  struct libnet_ethernet_hdr *eth = NULL;
  struct libnet_ip_hdr *ip = NULL;
  struct libnet_tcp_hdr *tcp = NULL;
  struct libnet_arp_hdr *arp = NULL;
  struct libnet_icmp_hdr *icmp = NULL;
  struct libnet_udp_hdr *udp = NULL;
  struct libnet_link_int *l;
  u_char * newpacket;
  u_char user_ip[IPV4_ADDR_LEN + 1];
  u_char upstream_ip[IPV4_ADDR_LEN + 1];
  u_char test_ip[IPV4_ADDR_LEN + 1];
  struct in_addr test_ipa;
  
/* Adresy MAC = Lokalne adresy sprzetowe poziomu lacza w sieci */
  u_char user_mac[ETHER_ADDR_LEN + 1];	/* Adres MAC pobierania pakietow */
  u_char upstream_mac[ETHER_ADDR_LEN + 1];	/* Adres MAC przekazywania pakietow */
  u_char bcast_mac[ETHER_ADDR_LEN + 1];	/* Adres przekazywania dla wszystkich MAC */
  u_char test_mac[ETHER_ADDR_LEN + 1];	/* Bufor sluzacy do testowania */
  char errbuf[255];
  int do_checksum = 0;
  int verbose = 0;
  int i = 0;
  
/* Ustaw adres rozglaszania Broadcast MAC na FF:FF:FF:FF:FF:FF */
  bcast_mac[0] = 0xFF;
  bcast_mac[1] = 0xFF;
  bcast_mac[2] = 0xFF;
  bcast_mac[3] = 0xFF;
  bcast_mac[4] = 0xFF;
  bcast_mac[5] = 0xFF;
  
/* Ustaw domyslny adres MAC obszaru uzytkownikow na 00:E0:B0:B0:D0:D0 */
  user_mac[0] = 0x00;
  user_mac[1] = 0xE0;
  user_mac[2] = 0xB0;
  user_mac[3] = 0xB0;
  user_mac[4] = 0xD0;
  user_mac[5] = 0xD0;
  
/* Ustaw domyslny adres IP rzeczywistej bramki */
  upstream_ip[0] = 10;
  upstream_ip[1] = 0;
  upstream_ip[2] = 1;
  upstream_ip[3] = 254;
  
/* Ustaw domyslny interfejs */
    snprintf (dev, sizeof (dev), "%s", pcap_lookupdev (NULL));
  
/* Opcje analizatora */ 
    while ((opt = getopt (argc, argv, "i:r:R:m:cv")) != EOF)
    {
      switch (opt)
	{
	case 'i':		/* Interfejs */
	  snprintf (dev, sizeof (dev), "%s", optarg);
	  break;
	case 'v':
	  verbose = 1;
	  break;
	case 'r':		/* Adres IP rutera */
	  sscanf (optarg, "%hu.%hu.%hu.%hu", &upstream_ip[0],
		   &upstream_ip[1], &upstream_ip[2], &upstream_ip[3]);
	  break;
	case 'R':		/* Adres MAC rutera */
	  sscanf (optarg, "%X:%X:%X:%X:%X:%X", &upstream_mac[0],
		   &upstream_mac[1], &upstream_mac[2], &upstream_mac[3],
		   &upstream_mac[4], &upstream_mac[5]);
	  break;
	case 'm':		/* Adres MAC obszaru uzytkownikow */
	  sscanf (optarg, "%X:%X:%X:%X:%X:%X", &user_mac[0], &user_mac[1],
		   &user_mac[2], &user_mac[3], &user_mac[4], &user_mac[5]);
	  break;
	case 'c':		/* Suma kontrolna */
	  do_checksum = 1;
	  break;
	default:
	  usage ();
	}
    }
  
    /* Pobierz adres IP obszaru uzytkownikow */
    if (argv[optind] != NULL)
    {
      sscanf (argv[optind], "%hu.%hu.%hu.%hu", &user_ip[0], &user_ip[1],
	       &user_ip[2], &user_ip[3]);
    }
  else
    usage ();
  
/* Rozpocznij monitorowanie */ 
    pcap = pcap_open_live (dev, 65535, promisc, 5, NULL);
  if (pcap == NULL)
    {
      perror ("pcap_open_live");
      exit (EXIT_FAILURE);
    }
  if (ioctl (pcap_fileno (pcap), BIOCIMMEDIATE, &immediate))
    {
      
	/*perror(Nie mozna ustawic BPF na tryb natychmiastowy (Immediate Mode)."); */ 
    }
  
/*
 * Utwrz filtr sluzacy do przechwytywania pakietow zadan ARP,
 * ICMP oraz rutowania.
 */ 
    snprintf (pfprogram, sizeof (pfprogram),
	      "arp or icmp or ether dst %hX:%hX:%hX:%hX:%hX:%hX", user_mac[0],
	      user_mac[1], user_mac[2], user_mac[3], user_mac[4],
	      user_mac[5]);
  
/* Skompiluj i ustaw oparty na jadrze filtr pakietow */
    if (pcap_compile (pcap, &fp, pfprogram, 1, 0x0) == -1)
    {
      pcap_perror (pcap, "pcap_compile");
      exit (EXIT_FAILURE);
    }
  if (pcap_setfilter (pcap, &fp) == -1)
    {
      pcap_perror (pcap, "pcap_setfilter");
      exit (EXIT_FAILURE);
    }
  
/* Pobierz bezposrednie polaczenie z interfejsem */
    if ((l = libnet_open_link_interface (dev, errbuf)) == NULL)
    {
      fprintf (stderr, "Blad libnet przy otwieraniu interfejsu lacza: %s", errbuf);
    }
  
/* Znajdz ruter */ 
  libnet_init_packet (LIBNET_ETH_H + LIBNET_ARP_H, &newpacket);
  libnet_build_ethernet (bcast_mac, /* eth->ether_dhost */ 
			  user_mac, /* eth->ether_shost */ 
			  ETHERTYPE_ARP, /* eth->ether_type */ 
			  NULL, /* dodatkowe dane do dolaczenia */ 
			  0, /* ilosc dodatkowych danych */ 
			  newpacket);
  libnet_build_arp (ARPHRD_ETHER, ETHERTYPE_IP, ETHER_ADDR_LEN,
		     IPV4_ADDR_LEN, ARPOP_REQUEST, user_mac, user_ip,
		     bcast_mac, upstream_ip, NULL, 0,
		     newpacket + LIBNET_ETH_H);
  i =
    libnet_write_link_layer (l, dev, newpacket, LIBNET_ETH_H + LIBNET_ARP_H);
  if (verbose)
    {
      fprintf (stdout, "ZADANIE ARP: Zapisano %i bajtow szukajac ", i);
      print_ip (stdout, upstream_ip);
    }
  libnet_destroy_packet (&newpacket);
  
/* Pobierz nastepny pakiet z kolejki */
    while (1)
    {
      packet = (u_char *) pcap_next (pcap, &pkthdr);
      if (packet)
	{
	  
/*
* Uczyn pakiet mozliwym do analizy -- wlaczanie
* eth->ether_type oraz ip->ip_p jest takze poprawna
* strategia. Wszystkie struktury zdefiniowano w
* /usr/include/libnet/libnet-headers.h
*/
	    
/* Warstwa 1.: struktury libnet_ethernet_hdr */
	    (char *) eth = (char *) packet;
	  
/* Warstwa 2.: struktury libnet_arp_hdr / libnet_ip_hdr */
	    (char *) arp = (char *) ip = (char *) packet + LIBNET_ETH_H;
	  
/* Warstwa 3.: struktury libnet_icmp_hdr / libnet_tcp_hdr / libnet_udp_hdr structs */ 
	    (char *) icmp = (char *) tcp = (char *) udp =
	    (char *) packet + LIBNET_ETH_H + LIBNET_IP_H;
	  
/* Obsluz ARP: */
	    if (ntohs (eth->ether_type) == ETHERTYPE_ARP
		&& arp->ar_op == htons (ARPOP_REQUEST)
		&& !memcmp (arp->ar_tpa, user_ip, IPV4_ADDR_LEN))
	    {
	      
        /*
         * Jesli naglowek ethernetowy wskazuje, ze jest to
         * pakiet ARP, naglowek ARP wskazuje, ze jest to
         * zadanie translacji, a poszukiwany adres
         * odpowiada temu "stosowi"...
         *
         */
	      memcpy (eth->ether_dhost, eth->ether_shost, ETHER_ADDR_LEN);
	      memcpy (eth->ether_shost, user_mac, ETHER_ADDR_LEN);
	      memcpy (arp->ar_tha, arp->ar_sha, ETHER_ADDR_LEN);
	      memcpy (arp->ar_sha, user_mac, ETHER_ADDR_LEN);
	      arp->ar_op = htons (ARPOP_REPLY);
	      memcpy (test_ip, arp->ar_spa, IPV4_ADDR_LEN);
	      memcpy (arp->ar_spa, arp->ar_tpa, IPV4_ADDR_LEN);
	      memcpy (arp->ar_tpa, test_ip, IPV4_ADDR_LEN);
	      i = libnet_write_link_layer (l, dev, packet, pkthdr.caplen);
	      if (verbose)
		    fprintf (stdout, "ARP: Zapisano %i bajtow\n", i);
	      
/* Obsluz odpowiedzi ARP (odpowiadajac rzeczywistym adresem IP) */
	    }
	  else if (eth->ether_type == ntohs (ETHERTYPE_ARP)
		   && arp->ar_op == htons (ARPOP_REPLY)
		   && !memcmp (arp->ar_spa, upstream_ip, IPV4_ADDR_LEN))
	    {
	      memcpy (upstream_mac, arp->ar_sha, ETHER_ADDR_LEN);
	      if (verbose)
		fprintf (stdout,
			  "Znaleziono ruter: %hu.%hu.%hu.%hu at %X:%X:%X:%X:%X:%X\n",
			  upstream_ip[0], upstream_ip[1], upstream_ip[2],
			  upstream_ip[3], upstream_mac[0], upstream_mac[1],
			  upstream_mac[2], upstream_mac[3], upstream_mac[4],
			  upstream_mac[5]);
	      
/* Obsluz ICMP ECHO (Ping) */
	    }
	  else if (!memcmp (eth->ether_dhost, user_mac, ETHER_ADDR_LEN)
		   && ntohs (eth->ether_type) == ETHERTYPE_IP
		   && memcmp ((u_char *) & ip->ip_dst, user_ip,
			       IPV4_ADDR_LEN) && ip->ip_p == IPPROTO_ICMP
		   && icmp->icmp_type == ICMP_ECHO)
	    {
	      
/* Zamien zrodlowy i docelowy adres MAC */
		 memcpy (test_mac, eth->ether_dhost, ETHER_ADDR_LEN);
	      memcpy (eth->ether_dhost, eth->ether_shost, ETHER_ADDR_LEN);
	      memcpy (eth->ether_shost, test_mac, ETHER_ADDR_LEN);
	      
/* Zamie rdowy i docelowy adres IP */
		 test_ipa = ip->ip_dst;
	      ip->ip_dst = ip->ip_src;
	      ip->ip_src = test_ipa;
/*
 * Zamien pakiet na odpowiedz i zmniejsz parametr czasu zycia TTL
 */ 
		 icmp->icmp_type = ICMP_ECHOREPLY;
	      ip->ip_ttl--;
	      
/* Oblicz ponownie sumy kontrolne IP oraz TCP/UDP/ICMP */
		 libnet_do_checksum (packet + LIBNET_ETH_H, IPPROTO_IP,
				   LIBNET_IP_H);
	      libnet_do_checksum (packet + LIBNET_ETH_H, IPPROTO_ICMP,
				   pkthdr.caplen - LIBNET_ETH_H -
				   LIBNET_IP_H);
	      i = libnet_write_link_layer (l, dev, packet, pkthdr.caplen);
	      if (verbose)
		fprintf (stdout, "ICMP: Zapisano %i bajtow\n", i);
	      
/* Pakiet rutowania */ 
	    }
	  else if (!memcmp (eth->ether_dhost, user_mac, ETHER_ADDR_LEN))
	    {
	      memcpy (eth->ether_dhost, upstream_mac, ETHER_ADDR_LEN);
	      memcpy (eth->ether_shost, user_mac, ETHER_ADDR_LEN);
	      if (do_checksum == 1)
		{
		  ip->ip_ttl--;
		  libnet_do_checksum (packet + LIBNET_ETH_H, IPPROTO_IP,
				       LIBNET_IP_H);
		  libnet_do_checksum (packet + LIBNET_ETH_H, ip->ip_p,
				       ntohs (ip->ip_len) - LIBNET_IP_H);
		}
	      i = libnet_write_link_layer (l, dev, packet, pkthdr.caplen);
	      if (verbose)
		fprintf (stdout, "DANE: Przeslano %i bajtow do %s\n", i,
			  inet_ntoa (ip->ip_dst));
	    }
	}
    }
  
/* Na razie tyle... */ 
    pcap_close (pcap);
  return EXIT_SUCCESS;
}
void 
print_ip (FILE * stream, u_char * ip) 
{
  fprintf (stream, "%i.%i.%i.%i\n", ip[0], ip[1], ip[2], ip[3]);
}
void 
print_mac (FILE * stream, u_char * mac) 
{
  fprintf (stream, "%X:%X:%X:%X:%X:%X\n", mac[0], mac[1], mac[2], mac[3],
	    mac[4], mac[5]);
}
void
usage () 
{
  fprintf (stderr,
	    "DoxRoute 0.1: Userspace TCP/IP Router, by Dan Kaminsky (dan@doxpara.com)\n");
  fprintf(stderr, 
         "      Uzycie: doxroute [-i interfejs] [-m mac_obszaru_uzytkownikow]\n");
  fprintf(stderr,
         "                       [-r/R rzeczywisty_ip/mac] [-cv] ip_obszaru_uzytkownikow\n\n");
  fprintf(stderr, "      Przyklad: doxroute -r 10.0.1.254 10.0.1.169\n");
  fprintf(stderr, "      Opcje: \n");
  fprintf(stderr, 
         "              -i [interface] : Okresl interfejs do wykorzystania.\n");
  fprintf(stderr, 
         "              -r [upstream_ip] : Adres MAC rzeczywistego rutera\n");
  fprintf(stderr,
         "              -R [upstream_mac] : Adres MAC rzeczywistego rutera/bramki.\n");
  fprintf(stderr, 
         "              -m [userspace_mac]: Adres MAC dla niniejszego programu.\n");
  fprintf(stderr, 
         "              -c : Weryfikuj sumy kontrolne(i zmniejszaj parametr IP TTL).\n");
  fprintf(stderr, "     -v : Opisowy tryb dzialania.\n");
  fprintf(stderr, 
         "    Uwaga: Jest to jedynie wersja probna. Uzyteczne narzedzie pozniej.\n");
  exit (1);
}

