/*
    Findjmp.c
    autor: Ryan Permeh - ryan@eeye.com
    http://www.eeye.com
*/

#include <Windows.h>
#include <stdio.h>

void usage();
DWORD GetRegNum(char *reg);
void findjmp(char *dll, char *reg);

/* Program wyszukuje przydatne do atakow adresy instrukcji skokow w bibliotekach DLL.
   Po przepelnieniu bufora prawdopodobne jest, ze odwolanie do podsunietego kodu
   znajduje sie juz w jednym z rejestrow procesora. Program wyszukuje adresy, ktore
   mozna wprowadzic do rejestru EIP w celu przekazania sterowania do podsunietego
   kodu ladunku. */

int main(int argc, char **argv)
{
        char dll[512],  // zmienna przechowujaca nazwe biblioteki
        reg[512];       // zmienna przechowujaca symbol rejestru

        if (argc < 2) usage();
        strncpy(dll, argv[1], 512);
        strncpy(reg, argv[2], 512);
        findjmp(dll, reg);
}

void usage()
{
        printf("FindJmp:\nfindjmp DLL reg\nNp.: findjmp KERNEL32.DLL ESP\n");
        exit(0);
}
/* Koniem roboczym programu jest funkcja findjmp(). Wczytuje ona wskazana biblioteke
   dll i wyszukuje w niej okreslone wzorce odpowiadajace instrukcjom (sekwencjom
   instrukcji) jmp rejestr, push rejestr ret oraz call rejestr. */

void findjmp(char *dll, char *reg)
{
        /* wzorce instrukcji jmp */
BYTE jmppat[8][2] = {{0xFF, 0xE0}, {0xFF, 0xE3}, {0xFF, 0xE1}, {0xFF, 0xE2},
                     {0xFF, 0xE6}, {0xFF, 0xE7}, {0xFF, 0xE4}, {0xFF, 0xE5}};
        /* wzorce instrukcji call */
BYTE callpat[8][2] = {{0xFF, 0xD0}, {0xFF, 0xD3}, {0xFF, 0xD1}, {0xFF, 0xD2},
                      {0xFF, 0xD6}, {0xFF, 0xD7}, {0xFF, 0xD4}, {0xFF, 0xD5}};
        /* wzorce instrukcji push-ret */
BYTE pushretpat[8][2] = {{0x50, 0xC3}, {0x53, 0xC3}, {0x51, 0xC3}, {0x52, 0xC3},
                         {0x56, 0xC3}, {0x57, 0xC3}, {0x54, 0xC3}, {0x55, 0xC3}};

        /* wskanik bazowy ladowanej biblioteki dll */
        HMODULE loadedDLL;

        /* aktualna pozycja w bibliotece */
        BYTE *curpos;

        /* reprezentacja dziesietna rejestru */
        DWORD regnum = GetRegNum(reg);

        /* akumulator adresw */
        DWORD numaddr=0;

        /* sprawdz, czy przekazano odpowiedni rejestr */
        if (regnum == 1)
        {
        /* przekazano nieodpowiedni rejestr */
                printf("Nie rozpoznano rejestru.\n"\
                "Sprawdz, czy przekazano odpowiednia nazwe rejestru IA32\n"\
                "Obslugiwane sa nastepujace rejestry:\n "\
                "EAX, EBX, ECX, EDX, ESI, EDI, ESP, EBP\n");

                exit(-1);
        }

        loadedDLL = LoadLibraryA(dll);

        /* sprawdz, czy biblioteka zostala poprawnie zaladowana */
        if (loadedDLL == NULL)
        {
        /* ladowanie biblioteki nieudane */
                printf("Nie udalo sie zaladowac wskazanej biblioteki DLL.\n"\
                "Sprawdz, czy wskazana biblioteka znajduje sie w zmiennej PATH\n")
                exit(-1);
        }
        else
        {
        /* udalo sie zaladowac biblioteke, pora ja przeskanowac */
                printf("Skanowanie %s w poszukiwaniu kodu wykorzystujacego rejestr %s\n", dll, reg);
              /* ustaw curpos na poczatek biblioteki */
                curpos = (BYTE*) loadedDLL;

                __try
                {
                while(1)
                {
              /* dopasowanie wzorca jmp */
                        if (!memcmp(curpos, jmppat[regnum],2))
                        {
                        /* dopasowanie pozytywne */
                              printf("ox%X\tjmp %s\n", curpos, reg)
                              numaddr++;
                        }
              /* dopasowanie wzorca jmp */
                        else if (!memcmp(curpos, callpat[regnum],2))
                        {
                        /* dopasowanie pozytywne */
                              printf("ox%X\tcall %s\n", curpos, reg)
                              numaddr++;
                        }
              /* dopasowanie wzorca push-ret */
                        else if (!memcmp(curpos, pushretpat[regnum],2))
                        {
                        /* dopasowanie pozytywne */
                              printf("ox%X\tpush %s - ret\n", curpos, reg)
                              numaddr++;
                        }
                        curpos++;
                }
                }
                __except(1)
                {
                        printf("Zakonczono skanowanie %s pod katem kodu odwolujacego sie"\
                        "do rejestru %s\n", dll, reg);
                        printf("Znaleziono %d uzytecznych adresow\n", numaddr);
                }
        }
}


DWORD GetRegNum(char *reg)
{
        DWORD ret = 1;
        if (!stricmp(reg, "EAX"))
        {
                ret = 0;
        }
        else if (!stricmp(reg, "EBX"))
        {
                ret = 1;
        }
        else if (!stricmp(reg, "ECX"))
        {
                ret = 2;
        }
        else if (!stricmp(reg, "EDX"))
        {
                ret = 3;
        }
        else if (!stricmp(reg, "ESI"))
        {
                ret = 4;
        }
        else if (!stricmp(reg, "EDI"))
        {
                ret = 5;
        }
        else if (!stricmp(reg, "ESP"))
        {
                ret = 6;
        }
        else if (!stricmp(reg, "EBP"))
        {
                ret = 7;
        }
        /* zwroc numer rejestru */
        return ret;
}
