#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ID_LEN 40

/* wyświetl komunikat i zakończ */
void barf(char *message, void *extra) {
   printf(message, extra);
   exit(1);
}

/* udajemy, że ta funkcja aktualizuje opis produktu w bazie danych */
void update_product_description(char *id, char *desc)
{
   char product_code[5];
   strcpy(product_code, id);

   // aktualizuj bazę danych
   printf("Zmieniam opis produktu nr %s na \'%s\'\n", product_code, desc);
}

int main(int argc, char *argv[], char *envp[])
{
  int i;
  char *id, *desc;

  if(argc < 2)
     barf("Sposób użycia: %s <identyfikator> <opis>\n", argv[0]);
  id = argv[1];   // id - kod produktu do zaktualizowania w bazie danych
  desc = argv[2]; // desc - nowy tekst opisu

  if(strlen(id) > MAX_ID_LEN) // id musi być mniejszy niż MAX_ID_LEN bajtów
     barf("Błąd krytyczny: argument id musi być krótszy niż %u bajtów\n", (void *)MAX_ID_LEN);

  for(i=0; i < strlen(desc)-1; i++) { // w desc zezwalaj tylko na znaki drukowalne
     if(!(isprint(desc[i]))) 
        barf("Błąd krytyczny: argument z opisem może zawierać jedynie bajty drukowalne\n", NULL);
  }

  // czyszczenie pamięci stosu (zabezpieczenie)
  // czyszczenie wszystkich argumentów poza pierwszym i drugim
  memset(argv[0], 0, strlen(argv[0]));
  for(i=3; argv[i] != 0; i++)
    memset(argv[i], 0, strlen(argv[i]));
  // czyszczenie wszystkich zmiennych środowiskowych
  for(i=0; envp[i] != 0; i++)
    memset(envp[i], 0, strlen(envp[i]));

  printf("[DEBUG]: argument desc znajduje się pod adresem %p\n", desc);
  update_product_description(id, desc); // aktualizuj bazę danych
}
