#include <sys/stat.h> 
#include <sys/socket.h> 
#include <netinet/in.h> 
#include <arpa/inet.h> 
#include <sys/types.h> 
#include <sys/stat.h> 
#include <fcntl.h> 
#include <time.h> 
#include <signal.h> 
#include "hacking.h" 
#include "hacking-network.h" 

#define PORT 80   // port, z którym będą się łączyć użytkownicy
#define WEBROOT "./webroot" // główny katalog serwera www
#define LOGFILE "/var/log/tinywebd.log" // nazwa pliku dziennika
   
int logfd, sockfd;  // globalne deskryptory pliku dziennika i gniazda
void handle_connection(int, struct sockaddr_in *, int); 
int get_file_size(int); // zwraca rozmiar pliku otwartego deskryptora pliku
void timestamp(int); // zapisuje znacznik czasu do deskryptora otwartego pliku

// Ta funkcja jest wywoływana przy zabiciu procesu
void handle_shutdown(int signal) { 
   timestamp(logfd); 
   write(logfd, "Kończę pracę..\n", 18); 
   close(logfd); 
   close(sockfd); 
   exit(0); 
} 

int main(void) {
   int sockfd, new_sockfd, yes=1; 
   struct sockaddr_in host_addr, client_addr;   // informacje o moim adresie
   socklen_t sin_size;

   logfd = open(LOGFILE, O_WRONLY|O_CREAT|O_APPEND, S_IRUSR|S_IWUSR); 
   if(logfd == -1) 
      fatal("otwieranie pliku dziennika");

   if ((sockfd = socket(PF_INET, SOCK_STREAM, 0)) == -1)
      fatal("w socket");

   if (setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(int)) == -1)
      fatal("ustawianie opcji SO_REUSEADDR gniazda");
      
   printf("Uruchamiam demona tiny web..\n"); 
   if(daemon(1, 0) == -1) // rozwidlenie do procesu tła demona
      fatal("przy rozwidleniu do procesu tła demona"); 
   
   signal(SIGTERM, handle_shutdown);   // wywołaj handle_shutdown przy zabiciu
   signal(SIGINT, handle_shutdown);   // wywołaj handle_shutdown przy przerwaniu
   
   timestamp(logfd); 
   write(logfd, "Rozpoczęcie pracy..\n", 21);    
   host_addr.sin_family = AF_INET;      // kolejność bajtów hosta
   host_addr.sin_port = htons(PORT);    // short, sieciowa kolejność bajtów
   host_addr.sin_addr.s_addr = INADDR_ANY; // automatycznie wypełnij moim IP
   memset(&(host_addr.sin_zero), '\0', 8); // zeruj resztę struktury

   if (bind(sockfd, (struct sockaddr *)&host_addr, sizeof(struct sockaddr)) == -1)
      fatal("wiązanie do gniazda");

   if (listen(sockfd, 20) == -1)
      fatal("słuchanie na gnieździe");

   while(1) {   // Pętla akceptująca
      sin_size = sizeof(struct sockaddr_in);
      new_sockfd = accept(sockfd, (struct sockaddr *)&client_addr, &sin_size);
      if(new_sockfd == -1)
         fatal("akceptowanie połączenia");

      handle_connection(new_sockfd, &client_addr, logfd);
   }
   return 0;
}

/* Ta funkcja obsługuje połączenie na przesłanym gnieździe, pochodzące
 * od przesłanego adresu klienta i zapisuje dziennik do przesłanego deskryptora pliku. 
 * Połączenie jest przetwarzane jako żądanie WWW i ta funkcja odpowiada przez połączone gniazdo. 
 * Ostatecznie przesłane gniazdo jest zamykane na końcu funkcji.
 */
void handle_connection(int sockfd, struct sockaddr_in *client_addr_ptr, int logfd) {
   unsigned char *ptr, request[500], resource[500], log_buffer[500];
   int fd, length;

   length = recv_line(sockfd, request);

   sprintf(log_buffer, "Od %s:%d \"%s\"\t", inet_ntoa(client_addr_ptr->sin_addr), ntohs(client_addr_ptr->sin_port), request); 

   ptr = strstr(request, " HTTP/"); // szukaj prawidłowo wyglądającego żądania
   if(ptr == NULL) { // wówczas ne jest to poprawny HTTP
      printf(" TO NIE JEST HTTP!\n");
   } else {
      *ptr = 0; // zakończ bufor na końcu URL
      ptr = NULL; // ustaw ptr na NULL (używane do oznaczenia nieprawidłowego żądania)
      if(strncmp(request, "GET ", 4) == 0)  // żądanie get 
         ptr = request+4; // ptr to URL
      if(strncmp(request, "HEAD ", 5) == 0) // żądanie head 
         ptr = request+5; // ptr to URL

      if(ptr == NULL) { // wtedy żądanie nie jest rozpoznawane
         printf("\tNIEZNANY TYP ŻĄDANIA!\n");
      } else { // prawidłowe żądanie, ptr wskazuje na nazwę zasobu
         if (ptr[strlen(ptr) - 1] == '/')  // w przypadku zasobów kończących się znakiem '/'
            strcat(ptr, "index.html");     // dopisz na końcu 'index.html' 
         strcpy(resource, WEBROOT);     // rozpocznij ścieżkę do zasobu ścieżką do głównego katalogu WWW
         strcat(resource, ptr);         //  i połącz ją ze ścieżką zasobu
         fd = open(resource, O_RDONLY, 0); // spróbuj otworzyć plik
         printf("\tOpening \'%s\'\t", resource);
         if(fd == -1) { // jeżeli nie odnaleziono pliku
            strcat(log_buffer, " 404 Nie znaleziono pliku\n");
            send_string(sockfd, "HTTP/1.0 404 NOT FOUND\r\n");
            send_string(sockfd, "Serwer: Tiny webserver\r\n\r\n");
            send_string(sockfd, "<html><head><title>404 Nie znaleziono</title></head>");
            send_string(sockfd, "<body><h1>URL nie znaleziony</h1></body></html>\r\n");
         } else {      // w przeciwnym przypadku dostarcz plik
            strcat(log_buffer, " 200 OK\n");
            send_string(sockfd, "HTTP/1.0 200 OK\r\n");
            send_string(sockfd, "Serwer: Tiny webserver\r\n\r\n");
            if(ptr == request + 4) { // wówczas jest to żądanie GET 
               if( (length = get_file_size(fd)) == -1)
                  fatal("przy pobieraniu rozmiaru zasobu");
               if( (ptr = (unsigned char *) malloc(length)) == NULL)
                  fatal("przy alokacji pamięci dla odczytu zasobu");
               read(fd, ptr, length); // wczytaj plik do pamięci
               send(sockfd, ptr, length, 0);  // prześlij go do gniazda
               free(ptr); // zwolnij pamięć pliku
            }
            close(fd); // zamknij plik
         } // koniec bloku 'if' dla odnalezienia (nieznalezienia) pliku
      } // koniec bloku 'if' dla prawdiłowego żądania
   } // koniec bloku 'if' testującego poprawność HTTP
   timestamp(logfd); 
   length = strlen(log_buffer); 
   write(logfd, log_buffer, length); // zapis do dziennika

   shutdown(sockfd, SHUT_RDWR); // zamknij gniazdo
}

/* Ta funkcja przyjmuje deskryptor otwartego pliku i zwraca
 * rozmiar powiązanego pliku.  Przy niepowodzeniu zwraca -1.
 */
int get_file_size(int fd) {
   struct stat stat_struct;

   if(fstat(fd, &stat_struct) == -1)
      return -1;
   return (int) stat_struct.st_size;
}


/* Ta funkcja zapisuje łańcuch znacznika czasu 
 * do przesłanego deskryptora otwartego pliku
 */ 
void timestamp(fd) { 
   time_t now; 
   struct tm *time_struct; 
   int length; 
   char time_buffer[40]; 

   time(&now);  // pobierz liczbę sekund od epoki
   time_struct = localtime((const time_t *)&now); // konwertuj na strukturę tm 
   length = strftime(time_buffer, 40, "<%m/%d/%Y %H:%M:%S> ", time_struct); 
   write(fd, time_buffer, length); // zapisz znacznik czasu do dziennika
}

