#include <libnet.h>
#include <pcap.h>
#include "hacking.h"

#define MAX_EXISTING_PORTS 30

void caught_packet(u_char *, const struct pcap_pkthdr *, const u_char *);
int set_packet_filter(pcap_t *, struct in_addr *, u_short *);

struct data_pass {
   int libnet_handle;
   u_char *packet;
};

int main(int argc, char *argv[]) {
   struct pcap_pkthdr cap_header;
   const u_char *packet, *pkt_data;
   pcap_t *pcap_handle;
   char errbuf[PCAP_ERRBUF_SIZE]; // taki sam rozmiar jak LIBNET_ERRBUF_SIZE
   char *device;
   u_long target_ip;
   int network, i;
   struct data_pass critical_libnet_data;
   u_short existing_ports[MAX_EXISTING_PORTS];

   if((argc < 2) || (argc > MAX_EXISTING_PORTS+2)) {
      if(argc > 2)
         printf("Ograniczone do śledzenia %d istniejących portów.\n", MAX_EXISTING_PORTS);
      else
         printf("Sposób użycia: %s <IP do zasłonięcia> [istniejące porty...]\n", argv[0]);
      exit(0);
   }

   target_ip = libnet_name_resolve(argv[1], LIBNET_RESOLVE);
   if (target_ip == -1)
      fatal("Nieprawidłowy adres celu");

   for(i=2; i < argc; i++)
      existing_ports[i-2] = (u_short) atoi(argv[i]);

   existing_ports[argc-2] = 0;

   device = pcap_lookupdev(errbuf);
   if(device == NULL)
      fatal(errbuf);

   pcap_handle = pcap_open_live(device, 128, 1, 0, errbuf);
   if(pcap_handle == NULL)
      fatal(errbuf);

   critical_libnet_data.libnet_handle = libnet_open_raw_sock(IPPROTO_RAW);
   if(critical_libnet_data.libnet_handle == -1)
      libnet_error(LIBNET_ERR_FATAL, "nie można otworzyć interfejsu sieciowego.  -- ten program musi być uruchomiony z uprawnieniami superużytkownika.\n");

   libnet_init_packet(LIBNET_IP_H + LIBNET_TCP_H, &(critical_libnet_data.packet));
   if (critical_libnet_data.packet == NULL)
      libnet_error(LIBNET_ERR_FATAL, "nie można zainicjalizować pamięci pakietu.\n");

   libnet_seed_prand();

   set_packet_filter(pcap_handle, (struct in_addr *)&target_ip, existing_ports);

   pcap_loop(pcap_handle, -1, caught_packet, (u_char *)&critical_libnet_data);
   pcap_close(pcap_handle);
}

/* ustawia filtr pakietów, aby wyszukiwał nawiązane połączenia TCP do target_ip */
int set_packet_filter(pcap_t *pcap_hdl, struct in_addr *target_ip, u_short *ports) {
   struct bpf_program filter;
   char *str_ptr, filter_string[90 + (25 * MAX_EXISTING_PORTS)];
   int i=0;

   sprintf(filter_string, "dst %s and ", inet_ntoa(*target_ip)); //  IP celu
   strcat(filter_string, "tcp[tcpflags] & tcp-syn != 0 and tcp[tcpflags] & tcp-ack = 0");

   if(ports[0] != 0) { // jeżeli występuje choć jeden istniejący port
      str_ptr = filter_string + strlen(filter_string);
      if(ports[1] == 0) // występuje tylko jeden istniejący port
         sprintf(str_ptr, " and not dst port %hu", ports[i]);
      else { // dwa lub więcej istniejących portów
         sprintf(str_ptr, " and not (dst port %hu", ports[i++]);
         while(ports[i] != 0) {
            str_ptr = filter_string + strlen(filter_string);
            sprintf(str_ptr, " or dst port %hu", ports[i++]);
         }
         strcat(filter_string, ")"); 
      }
   }
   printf("DEBUG: łańcuch filtru ma następującą postać \'%s\'\n", filter_string);
   if(pcap_compile(pcap_hdl, &filter, filter_string, 0, 0) == -1)
      fatal("pcap_compile zakończona niepowodzeniem");

   if(pcap_setfilter(pcap_hdl, &filter) == -1)
      fatal("pcap_setfilter zakończona niepowodzeniem");
}

void caught_packet(u_char *user_args, const struct pcap_pkthdr *cap_header, const u_char *packet) {
   u_char *pkt_data;
   struct libnet_ip_hdr *IPhdr;
   struct libnet_tcp_hdr *TCPhdr;
   struct data_pass *passed;
   int bcount;

   passed = (struct data_pass *) user_args; // przesyła dane korzystając ze wskaźnika do struktury 

   IPhdr = (struct libnet_ip_hdr *) (packet + LIBNET_ETH_H);
   TCPhdr = (struct libnet_tcp_hdr *) (packet + LIBNET_ETH_H + LIBNET_TCP_H);

   libnet_build_ip(LIBNET_TCP_H,      // rozmiar pakietu bez nagłówka IP
      IPTOS_LOWDELAY,                 // tos IP 
      libnet_get_prand(LIBNET_PRu16), // identyfikator IP (randomizowany) 
      0,                              // 
      libnet_get_prand(LIBNET_PR8),   // TTL (randomizowany) 
      IPPROTO_TCP,                    // protokół transportowy 
      *((u_long *)&(IPhdr->ip_dst)),  // IP źródłowe (udajemy, że jesteśmy celem) 
      *((u_long *)&(IPhdr->ip_src)),  // IP docelowe (wysyłamy z powrotem do źródła) 
      NULL,                           // ładunek (brak) 
      0,                              // długość ładunku
      passed->packet);                // pamięć nagłówka pakietu

   libnet_build_tcp(htons(TCPhdr->th_dport),// źródłowy port TCP (udajemy że jesteśmy celem) 
      htons(TCPhdr->th_sport),        // docelowy port TCP (odsyłamy do źródła) 
      htonl(TCPhdr->th_ack),          // sequence number (wykorzystaj poprzednie potwierdzenie) 
      htonl((TCPhdr->th_seq) + 1),    // numer potwierdzenia (numer sekwencyjny SYN + 1) 
      TH_SYN | TH_ACK,                // znaczniki sterujące (ustawiony jedynie RST ) 
      libnet_get_prand(LIBNET_PRu16), // rozmiar okna (randomizowany) 
      0,                              // wskaźnik pilności 
      NULL,                           // ładunek (brak)
      0,                              // długość ładunku
      (passed->packet) + LIBNET_IP_H);// pamięć nagłówka pakietu


   if (libnet_do_checksum(passed->packet, IPPROTO_TCP, LIBNET_TCP_H) == -1)
      libnet_error(LIBNET_ERR_FATAL, "nie można obliczyć sumy kontrolnej\n");

   bcount = libnet_write_ip(passed->libnet_handle, passed->packet, LIBNET_IP_H+LIBNET_TCP_H);
   if (bcount < LIBNET_IP_H + LIBNET_TCP_H)
      libnet_error(LIBNET_ERR_WARNING, "Uwaga: Zapisano niepełny pakiet.");
   printf("bing!\n");
}
