#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "hacking.h"

void usage(char *prog_name, char *filename) {
   printf("Sposób użycia: %s <dane do dopisania do pliku %s>\n", prog_name, filename);
   exit(0);
}

void fatal(char *);            // Funkcja do obsługi błędów krytycznych
void *ec_malloc(unsigned int); // Funkcja malloc() z mechanizmem sprawdzania błędów

int main(int argc, char *argv[]) {
   int userid, fd; // deskryptor pliku
   char *buffer, *datafile;

   buffer = (char *) ec_malloc(100);
   datafile = (char *) ec_malloc(20);
   strcpy(datafile, "/var/notes");

   if(argc < 2)                 // Jeżeli w wierszu polecenia nie podano argumentów,
      usage(argv[0], datafile); // wyświetl informacje o sposobie użycia i zakończ pracę.

   strcpy(buffer, argv[1]);  // Skopiuj do bufora.

   printf("[DEBUG] buffer (bufor)   @ %p: \'%s\'\n", buffer, buffer);
   printf("[DEBUG] datafile (plik z danymi) @ %p: \'%s\'\n", datafile, datafile);

// Otwieranie pliku
   fd = open(datafile, O_WRONLY|O_CREAT|O_APPEND, S_IRUSR|S_IWUSR);
   if(fd == -1)
      fatal("w main() przy otwieraniu pliku");
   printf("[DEBUG] deskryptor pliku to %d\n", fd);

   userid = getuid(); //  Pobiera prawdziwy ID użytkownika

// Zapisywanie danych
   if(write(fd, &userid, 4) == -1) // Zapisz ID użytkownika przed danymi.
      fatal("w main() podczas zapisywania identyfikatora użytkownika do pliku");
   write(fd, "\n", 1); // Zakończ wiersz.

   if(write(fd, buffer, strlen(buffer)) == -1) // Zapisz notatkę.
      fatal("w main() podczas zapisywania bufora do pliku");
   write(fd, "\n", 1); // Zakończ wiersz.

// Zamykanie pliku
   if(close(fd) == -1)
      fatal("w main() przy zamykaniu pliku");

   printf("Notatka została zapisana.\n");
   free(buffer);
   free(datafile);

}
