#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "hacking.h"

#define FILENAME "/var/notes"

int print_notes(int, int, char *);    //  Funkcja wypisująca notatki.
int find_user_note(int, int);         //  Szuka w pliku notatki dla użytkownika.
int search_note(char *, char *);      //  Funkcja wyszukująca słowo kluczowe.
void fatal(char *);                   //  Procedura obsługi błędów krytycznych

int main(int argc, char *argv[]) {
   int userid, printing=1, fd; // Deskryptor pliku
   char searchstring[100];

   if(argc > 1)                          // Jeżeli podano argument,
      strcpy(searchstring, argv[1]);     //   to jest to łańcuch do wyszukania;
   else                                  // w przeciwnym przypadku,
      searchstring[0] = 0;               //   łańcuch wyszukiwania jest pusty.

   userid = getuid();
   fd = open(FILENAME, O_RDONLY); // Otwiera plik w trybie tylko do odczytu.
   if(fd == -1)
      fatal("w main() przy otwieraniu pliku do odczytu");

   while(printing)
      printing = print_notes(fd, userid, searchstring);
   printf("-------[ koniec danych notatki ]-------\n");
   close(fd);
}

// Funkcja wypisująca notatki dla konkretnego uid, 
// zgodne z opcjonalnym łańcuchem wyszukiwania;
// zwraca 0, gdy napotka koniec pliku, a 1 gdy są jeszcze jakieś notatki.
int print_notes(int fd, int uid, char *searchstring) {
   int note_length;
   char byte=0, note_buffer[100];

   note_length = find_user_note(fd, uid);
   if(note_length == -1) // Jeżeli osiągnięty zostanie koniec pliku,
      return 0;           //   zwróć 0.

   read(fd, note_buffer, note_length); // Czytaj dane notatki.
   note_buffer[note_length] = 0;         // Zakończ łańcuch.

   if(search_note(note_buffer, searchstring)) // Jeżeli łańcuch zostanie odnaleziony,
      printf(note_buffer);                      // wypisz notatkę.
   return 1;
}

// Funkcja wyszukująca kolejną notatkę dla określonego ID użytkownika;
// zwraca -1 gdy osiągnięty zostanie koniec pliku;
// w przeciwnym przypadku zwraca długość znalezionej notatki.
int find_user_note(int fd, int user_uid) {
   int note_uid=-1;
   unsigned char byte;
   int length;

   while(note_uid != user_uid) {   // Pętla dopóki zostanie odnaleziona notatka dla user_uid.

      if(read(fd, &note_uid, 4) != 4) // Czytaj dane uid.
         return -1; // Jeżeli nie zostaną odczytane 4 bajty, zwróć kod końca pliku.
      if(read(fd, &byte, 1) != 1) // Czytaj separator nowego wiersza.
         return -1;

      byte = length = 0;
      while(byte != '\n') { // Określ ile bajtów zostało do końca wiersza.
         if(read(fd, &byte, 1) != 1) // Czytaj jeden bajt.
             return -1;     // Jeżeli bajt nie zostanie odczytany, zwróć kod końca pliku.
         length++;
      }
   }

   lseek(fd, length * -1, SEEK_CUR); // Przewiń odczyt pliku o 'length' bajtów.

   printf("[DEBUG] znaleziono %d bajtową notatkę dla użytkownika %d\n", length, note_uid);
   return length;
}

// Funkcja wyszukująca notatkę z określonym słowem kluczowym;
// zwraca 1 jeżeli odpowiednia notatka zostanie odnaleziona, 
// w przeciwnym przypadku zwraca 0.
int search_note(char *note, char *keyword) {
   int i, keyword_length, match=0;

   keyword_length = strlen(keyword);
   if(keyword_length == 0) // Jeżeli nie ma słowa kluczowego
      return 1;               // zawsze "znajduj".

   for(i=0; i < strlen(note); i++) { // Iteracja przez bajty w notatce.
      if(note[i] == keyword[match]) // Jeżeli bajt zgadza się ze słowem kluczowym,
         match++;    // przygotuj się do sprawdzenia kolejnego bajtu;
      else {         //   w przeciwnym przypadku,
         if(note[i] == keyword[0]) // jeżeli ten bajt jest zgodny z pierwszym bajtem słowa kluczowego,
             match = 1; // rozpocznij licznik dopasowań od 1.
         else
             match = 0; // W przeciwnym przypadku to 0.
      }
      if(match == keyword_length) // Jeżeli nastąpi pełne dopasowanie,
         return 1;    // zwróć kod dopasowania.
   }
   return 0; // Zwróć kod braku dopasowania.
}
