#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Funkcja wyświetlająca komunikat o błędzie i kończąca pracę
void fatal(char *message) {
   char error_message[100];

   strcpy(error_message, "[!!] Błąd krytyczny ");
   strncat(error_message, message, 83);
   perror(error_message);
   exit(-1);
}

// Funkcja opakowująca malloc() z kontrolą błędów
void *ec_malloc(unsigned int size) {
   void *ptr;
   ptr = malloc(size);
   if(ptr == NULL)
      fatal("w ec_malloc() przy alokacji pamięci");
   return ptr;
}

// zrzuca surowy obraz pamięci w formacie bajtów  szesnastkowych możliwym do wypisania
void dump(const unsigned char *data_buffer, const unsigned int length) {
	unsigned char byte;
	unsigned int i, j;
	for(i=0; i < length; i++) {
		byte = data_buffer[i];
		printf("%02x ", data_buffer[i]);  // wyświetla bajt w formacie szesnastkowym
		if(((i%16)==15) || (i==length-1)) {
			for(j=0; j < 15-(i%16); j++)
				printf("   ");
			printf("| ");
			for(j=(i-(i%16)); j <= i; j++) {  // wyświetla wypisywalne bajty z wiersza
				byte = data_buffer[j];
				if((byte > 31) && (byte < 127)) // poza zakresem znaków drukowalnych
					printf("%c", byte);
				else
					printf(".");
			}
			printf("\n"); // koniec wiersza zrzutu (każdy wiersz zawiera 16 bajtów)
		} // end if
	} // end for
}

