/* Ta funkcja przyjmuje deskryptor pliku gniazda i wskaźnik
 * do łańcucha do przesłania (zakończonego null). Funkcja sprawdza,
 * czy wszystkie bajty zostały przesłane. Zwraca 1 przy sukcesie
 * i 0 przy niepowodzeniu.
*/
int send_string(int sockfd, unsigned char *buffer) {
   int sent_bytes, bytes_to_send;
   bytes_to_send = strlen(buffer);
   while(bytes_to_send > 0) {
      sent_bytes = send(sockfd, buffer, bytes_to_send, 0);
      if(sent_bytes == -1)
         return 0; // return 0 on send error
      bytes_to_send -= sent_bytes;
      buffer += sent_bytes;
   }
   return 1; // zwróć 1 przy sukcesie
}

/* Ta funkcja przyjmuje deskryptor pliku gniazda i wskaźnik
 * do docelowego bufora. Odbiera z gniazda aż do napotkania
 * sekwencji bajtów EOL. Bajty EOL są czytane z gniazda, al
 * bufor celu jest kończony przed tymy bajtami. Zwraca rozmiar
 * przeczytanego wiersza (bez bajtów EOL)
*/
int recv_line(int sockfd, unsigned char *dest_buffer) {
#define EOL "\r\n" // sekwencja bajtów EOL (końca wiersza)
#define EOL_SIZE 2
   unsigned char *ptr;
   int eol_matched = 0;

   ptr = dest_buffer;
   while(recv(sockfd, ptr, 1, 0) == 1) { // czytaj jeden bajt
      if(*ptr == EOL[eol_matched]) { // czy jest to ogranicznik?
         eol_matched++;
         if(eol_matched == EOL_SIZE) { // jeżeli wszystkie bajty tworzą ogranicznik
            *(ptr+1-EOL_SIZE) = '\0'; // zakończ łańcuch
            return strlen(dest_buffer); // zwróć liczbę odebranych bajtów
         }
      } else {
         eol_matched = 0;
      }   
      ptr++; // zwiększ wskaźnik ustawiając go na kolejny bajt;
   }
   return 0; // znaki końca wiersza nie zostały znalezione
}


/* Struktura dla nagłówków ethernetowych */
#define ETHER_ADDR_LEN 6
#define ETHER_HDR_LEN 14

struct ether_hdr {
   unsigned char ether_dest_addr[ETHER_ADDR_LEN]; // Docelowy adres MAC
   unsigned char ether_src_addr[ETHER_ADDR_LEN];  // Źródłowy adres MAC
   unsigned short ether_type; // Typ pakietu ethernetowego
};

/* Struktura dla nagłówków protokołu IP */
struct ip_hdr {
   unsigned char ip_version_and_header_length; // długość połączonych wersji i nagłówka
   unsigned char ip_tos;          // typ usługi
   unsigned short ip_len;         // całkowita długość
   unsigned short ip_id;          // numer identyfikacyjny
   unsigned short ip_frag_offset; // przesunięcie i znaczniki
   unsigned char ip_ttl;          // czas ważności
   unsigned char ip_type;         // typ protokołu
   unsigned short ip_checksum;    // suma kontrolna
   unsigned int ip_src_addr;      // źródłowy adres IP
   unsigned int ip_dest_addr;     // docelowy adres IP
};

/* Struktura dla nagłówków TCP (Transmission Control Protocol) */
struct tcp_hdr {
   unsigned short tcp_src_port;   // źródłowy port TCP
   unsigned short tcp_dest_port;  // docelowy port TCP
   unsigned int tcp_seq;          // numer sekwencyjny TCP 
   unsigned int tcp_ack;          // numer potwierdzenia TCP 
   unsigned char reserved:4;      // 4 bity z 6 bitów przestzeni zarezerwowanej
   unsigned char tcp_offset:4;    // przesunięcie danych TCP dla hosta z little-endian
   unsigned char tcp_flags;       // Znaczniki TCP (i 2 bity z przestrzeni zarezerwowanej)
#define TCP_FIN   0x01
#define TCP_SYN   0x02
#define TCP_RST   0x04
#define TCP_PUSH  0x08
#define TCP_ACK   0x10
#define TCP_URG   0x20
   unsigned short tcp_window;     // rozmiar okna TCP 
   unsigned short tcp_checksum;   // suma kontrolna TCP 
   unsigned short tcp_urgent;     // wskaźnik pilności TCP 
};
