#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include <stdlib.h>
#include "hacking.h"

#define DATAFILE "/var/chance.data" // Plik przechowujący dane użytkownika

// Własna struktura user przechowująca informacje o użytkownikach
struct user {
   int uid;
   int credits;
   int highscore;
   char name[100];
   int (*current_game) ();
};

// Prototypy funkcji
int get_player_data();
void register_new_player();
void update_player_data();
void show_highscore();
void jackpot();
void input_name();
void print_cards(char *, char *, int);
int take_wager(int, int);
void play_the_game();
int pick_a_number();
int dealer_no_match();
int find_the_ace();
void fatal(char *);

// Zmienne globalne
struct user player;       // Struktura dla gracza

int main() {
   int choice, last_game;

   srand(time(0)); // Inicjalizuje generator liczb losowych z bieżącym czasem

   if(get_player_data() == -1)   // Próbuje odczytać z pliku dane gracza.
      register_new_player();     // Jeżeli nie ma danych, zarejestruj nowego gracza.

   while(choice != 7) {
      printf("-=[ Gry hazardowe: Menu ]=-\n");
      printf("1 - Zagraj w grę \"Wskaż liczbę\"\n");
      printf("2 - Zagraj w grę \"Rozdanie bez powtórzeń\"\n");
      printf("3 - Zagraj w grę \"Znajdź asa\"\n");
      printf("4 - Obejrzyj najwyższe wyniki\n");
      printf("5 - Zmień nazwę użytkownika\n");
      printf("6 - Przywróć na koncie 100 kredytów\n");
      printf("7 - Zakończ\n");
      printf("[Nazwa: %s]\n", player.name);
      printf("[Masz %u kredytów] -> ", player.credits);
      scanf("%d", &choice);

      if((choice < 1) || (choice > 7))
         printf("\n[!!] Cyfra %d nie jest dopuszczalnym wyborem.\n\n", choice);
      else if (choice < 4) {           // W przeciwnym przypadku wybrano jakąś grę.
            if(choice != last_game) { // Jeżeli wskaźnik do funkcji nie jest ustawiony,
               if(choice == 1)         // ustaw go na wybraną grę.
                   player.current_game = pick_a_number;
               else if(choice == 2)
                   player.current_game = dealer_no_match;
               else
                   player.current_game = find_the_ace;
               last_game = choice;     // i ustaw last_game.
            }
            play_the_game();           // Gramy w grę.
         }
      else if (choice == 4)
         show_highscore();
      else if (choice == 5) {
         printf("\nZmień nazwę użytkownika\n");
         printf("Wpisz nową nazwę: ");
         input_name();
         printf("Twoja nazwa użytkownika została zmieniona.\n\n");
      }
      else if (choice == 6) {
         printf("\nNa koncie przywrócono 100 kredytów.\n\n");
         player.credits = 100;
      }
   }
   update_player_data();
   printf("\nDziękuję za grę! Do zobaczenia.\n");
}

// Ta funkcja odczytuje z pliku dane gracza z bieżącym uid.
// Zwraca -1 jeżeli nie potrafi znaleźć danych gracza z bieżącym uid.
int get_player_data() {
   int fd, uid, read_bytes;
   struct user entry;

   uid = getuid();

   fd = open(DATAFILE, O_RDONLY);
   if(fd == -1) // Nie można otworzyć pliku, może nie istnieje
      return -1;
   read_bytes = read(fd, &entry, sizeof(struct user));     // Czytaj pierwszy kawałek.
   while(entry.uid != uid && read_bytes > 0) { // Pętla do odnalezienia właściwego uid.
      read_bytes = read(fd, &entry, sizeof(struct user)); // Czytaj dalej.
   }
   close(fd); // Zamknij plik.
   if(read_bytes < sizeof(struct user)) // To oznacza, że został osiągniety koniec pliku.
      return -1;
   else
      player = entry; // Skopiuj odczytany wpis do struktury player (gracza).
   return 1;          // Zwróć kod powodzenia.
}

// To jest funkcja rejestrująca nowego użytkownika.
// Tworzy ona nowe konto gracza i dołącza je do pliku.
void register_new_player() {
   int fd;
   printf("-=-={ Rejestracja nowego gracza }=-=-\n");
   printf("Wpisz swoje imię: ");
   input_name();
   player.uid = getuid();
   player.highscore = player.credits = 100;
   fd = open(DATAFILE, O_WRONLY|O_CREAT|O_APPEND, S_IRUSR|S_IWUSR);
   if(fd == -1)
      fatal("w register_new_player() podczas otwierania pliku");
   write(fd, &player, sizeof(struct user));
   close(fd);
   printf("\n%s witaj w grze!.\n", player.name);
   printf("Przyznano Ci %u kredytów.\n", player.credits);
}

// Ta funkcja zapisuje do pliku bieżące dane gracza.
// Jest używana głównie do uaktualniania liczby kredytów po rozgrywce.
void update_player_data() {
   int fd, i, read_uid;
   char burned_byte;
   fd = open(DATAFILE, O_RDWR);
   if(fd == -1) // Jeżeli otwieranie pliku się tutaj nie powiedzie, mamy duży problem.
      fatal("w update_player_data() przy otwieraniu pliku");
   read(fd, &read_uid, 4);          // Czytaj uid z pierwszej struktury.
   while(read_uid != player.uid) { // Pętla do odnalezienia odpowiedniego uid.
      for(i=0; i < sizeof(struct user) - 4; i++) // Czytaj resztę
         read(fd, &burned_byte, 1);               // tej struktury.
      read(fd, &read_uid, 4);       // Czytaj uid z kolejnej struktury.
   }
   write(fd, &(player.credits), 4);   // Aktualizuj liczbę kredytów.
   write(fd, &(player.highscore), 4); // Aktualizuj listę najwyższych wyników.
   write(fd, &(player.name), 100);    // Aktualizuj nazwę.
   close(fd);
}

// Ta funkcja wyświetla bieżący najwyższy wynik oraz
// nazwę gracza, który go ustanowił.
void show_highscore() {
   unsigned int top_score = 0;
   char top_name[100];
   struct user entry;
   int fd;

   printf("\n====================| NAJWYŻSZE WYNIKI |====================\n");
   fd = open(DATAFILE, O_RDONLY);
   if(fd == -1)
      fatal("w show_highscore() przy otwieraniu pliku");
   while(read(fd, &entry, sizeof(struct user)) > 0) { // Pętla aż do końca pliku.
      if(entry.highscore > top_score) {    // Jeżeli jest wyższy wynik,
            top_score = entry.highscore; // ustaw top_score na ten wynik
            strcpy(top_name, entry.name); // i top_name na tę nazwę użytkownika.
         }
   }
   close(fd);
   if(top_score > player.highscore)
      printf("%s uzyskał wynik %u\n", top_name, top_score);
   else
      printf("Twój najwyższy wynik to obecnie %u kredytów!\n", player.highscore);
   printf("======================================================\n\n");
}

// Ta funkcja po prostu przyznaje główną wygraną w grze "Wskaż liczbę".
void jackpot() {
   printf("*+*+*+*+*+* GŁÓWNA WYGRANA *+*+*+*+*+*\n");
   printf("Zdobyłeś główną wygranę w wysokości100 kredytów!\n");
   player.credits += 100;
}

// Ta funkcja jest wykorzystywana do wprowadzenia nazwy gracza, ponieważ
// scanf("%s", &cokolwiek) zatrzyma wejście po napotkaniu pierwszej spacji.
void input_name() {
   char *name_ptr, input_char='\n';
   while(input_char == '\n')     // Usuń pozostałe
      scanf("%c", &input_char); // znaki nowego wiersza.

   name_ptr = (char *) &(player.name); // name_ptr = adres nazwy gracza
   while(input_char != '\n') { // Pętla do napotkania nowego wiersza.
      *name_ptr = input_char;    // Umieść wpisany znak w tym samym polu.
      scanf("%c", &input_char); // Pobierz kolejny znak.
      name_ptr++;                // Zwiększ wskaźnik do nazwy.
   }
   *name_ptr = 0; // Zakończ łańcuch.
}

// Ta funkcja wypisuje 3 karty dla gry "Znajdź asa".
// Oczekuje komunikatu do wyświetlenia, wskaźnika do tablicy z kartami
// oraz karty, którą użytkownik wybrał w wejściu. Jeżeli user_pick
// ma wartość -1, wyświetlane są liczby umożliwiające dokonanie wyboru.
void print_cards(char *message, char *cards, int  user_pick) {
   int i;

   printf("\n\t*** %s ***\n", message);
   printf("       \t._.\t._.\t._.\n");
   printf("Karty:\t|%c|\t|%c|\t|%c|\n\t", cards[0], cards[1], cards[2]);
   if(user_pick == -1)
      printf(" 1 \t 2 \t 3\n");
   else {
      for(i=0; i < user_pick; i++)
         printf("\t");
      printf(" ^-- Twój wybór\n");
   }
}

// Ta funkcja wprowadza stawki dla gier "Rozdanie bez powtórzeń" 
// i "Znajdź asa". Oczekuje liczby dostępnych kredytów oraz poprzedniej 
// stawki. Zmienna previous_wager jest potrzebna jedynie jako drugi 
// zakład w grze "Znajdź asa". Funkcja zwraca -1, jeżeli stawka jest zbyt
// duża lub zbyt mała, a w przeciwnym przypadku zwraca stawkę.
int take_wager(int available_credits, int previous_wager) {
   int wager, total_wager;

   printf("Ile spośród dostępnych %d kredytów chciałbyś postawić? ", available_credits);
   scanf("%d", &wager);
   if(wager < 1) {   // Upewnij się, że stawka jest większa od 0.
      printf("Sprytne, ale musisz postawić liczbę dodatnią!\n");
      return -1;
   }
   total_wager = previous_wager + wager;
   if(total_wager > available_credits) { // Potwierdź dostępność kredytów
      printf("Całkowita stawka w wysokości %d to więcej niż posiadasz!\n", total_wager);
      printf("Masz tylko %d kredytów, spróbuj ponownie.\n", available_credits);
      return -1;
   }
   return wager;
}

// Ta funkcja zawiera pętlę umożliwiającą ponowne rozegranie bieżącej gry.
// Po każdej rozgrywce zapisuje też nową całkowitą liczbę kredytów.
void play_the_game() {
   int play_again = 1;
   int (*game) ();
   char selection;

   while(play_again) {
      printf("\n[DEBUG] wskaźnik current_game  @ 0x%08x\n", player.current_game);
      if(player.current_game() != -1) {         // Jeżeli gra przebiegła bez błędów o
         if(player.credits > player.highscore) // ustanowiono nowy najwyższy wynik,
            player.highscore = player.credits; // aktualizuj najwyższy wynik.
         printf("\nMasz teraz %u kredytów\n", player.credits);
         update_player_data();                  // Zapisz do pliku nową sumę kredytów.
         printf("Czy chcesz zagrać ponownie? (t/n) ");
         selection = '\n';
         while(selection == '\n')               // Usuń niepotrzebne znaki nowego wiersza.
            scanf("%c", &selection);
         if(selection == 'n')
            play_again = 0;
      }
      else               // To oznacza, że gra zwróciła błąd,
         play_again = 0; // więc powróć do menu głównego.
   }
}

// Ta funkcja jest grą "Wskaż liczbę".
// Zwraca -1, gdy gracz nie ma wystarczającej liczby kredytów.
int pick_a_number() {
   int pick, winning_number;

   printf("\n####### Wskaż liczbę ######\n");
   printf("Udział w tej grze kosztuje 10 kredytów. Po prostu wybierz liczbę\n");
   printf("z przedziału 1 do 20. Jeżeli wybierzesz trafnie,\n");
   printf("wygrasz główną nagrodę w wysokości 100 kredytów!\n\n");
   winning_number = (rand() % 20) + 1; // Wybierz liczbę z przedziału 1 do 20.
   if(player.credits < 10) {
      printf("Masz tylko %d kredytów. Za mało by zagrać!\n\n", player.credits);
      return -1; // Za mało kredytów by wejść do gry
   }
   player.credits -= 10; // Pobierz 10 kredytów.
   printf("Z Twojego konta pobrano 10 kredytów.\n");
   printf("Wybierz liczbę z przedziału 1 do 20: ");
   scanf("%d", &pick);

   printf("Zwycięską liczbą jest %d\n", winning_number);
   if(pick == winning_number)
      jackpot();
   else
      printf("Niestety nie wygrałeś.\n");
   return 0;
}

// To jest gra "Rozdanie bez powtórzeń".
// Zwraca -1 gdy gracz ma 0 kredytów.
int dealer_no_match() {
   int i, j, numbers[16], wager = -1, match = -1;

   printf("\n::::::: Rozdanie bez powtórzeń :::::::\n");
   printf("W tej grze możesz postawić maksymalnie wszystkie swoje kredyty.\n");
   printf("Wyświetlone zostanie 16 losowych liczb z przedziału 0 do 99.\n");
   printf("Jeżeli żadna z nich się nie powtórzy, otrzymujesz podwójną stawkę!\n\n");

   if(player.credits == 0) {
      printf("Nie masz żadnych kredytów do postawienia!\n\n");
      return -1;
   }
   while(wager == -1)
      wager = take_wager(player.credits, 0);

   printf("\t\t::: Wypisuję 16 losowo wybranych liczb :::\n");
   for(i=0; i < 16; i++) {
      numbers[i] = rand() % 100; // Wybierz liczbę z przedziału 0 do 99.
      printf("%2d\t", numbers[i]);
      if(i%8 == 7)               // Wypisz znak podziału wiersza co 8 liczb.
         printf("\n");
   }
   for(i=0; i < 15; i++) {       // Pętla wyszukująca powtórzenia.
      j = i + 1;
      while(j < 16) {
         if(numbers[i] == numbers[j])
            match = numbers[i];
         j++;
      }
   }
   if(match != -1) {
      printf("Powtórzyła się liczba %d!\n", match);
      printf("Tracisz %d kredytów.\n", wager);
      player.credits -= wager;
   } else {
      printf("Żadna liczba się nie powtórzyła! Wygrywasz %d kredytów!\n", wager);
      player.credits += wager;
   }
   return 0;
}

// To jest gra "Znajdź asa".
// Zwraca -1 gdy gracz ma 0 kredytów.
int find_the_ace() {
   int i, ace, total_wager;
   int invalid_choice, pick = -1, wager_one = -1, wager_two = -1;
   char choice_two, cards[3] = {'X', 'X', 'X'};

   ace = rand()%3; // Losowo ustaw asa.

   printf("******* Znajdź asa *******\n");
   printf("W tej grze możesz postawić maksymalnie wszystkie swoje kredyty.\n");
   printf("Zostaną rozdane trzy karty - dwie damy i jeden as.\n");
   printf("Jeżeli znajdziesz asa, wygrywasz stawkę.\n");
   printf("Po wskazaniu karty zostanie odsłonięta jedna z dam.\n");
   printf("W tym momencie możesz albo wybrać inną kartę\n");
   printf("albo zwiększyć stawkę.\n\n");

   if(player.credits == 0) {
      printf("Nie masz żadnych kredytów do postawienia!\n\n");
      return -1;
   }

   while(wager_one == -1) // Pętla aż do postawienia prawidłowej stawki.
      wager_one = take_wager(player.credits, 0);

   print_cards("Rozdaję karty", cards, -1);
   pick = -1;
   while((pick < 1) || (pick > 3)) { // Pętla aż do poprawnego wskazania.
      printf("Wybierz kartę: 1, 2, lub 3 ");
      scanf("%d", &pick);
   }
   pick--; // Popraw wybór, ponieważ numerowanie kart rozpoczyna się od 0.
   i=0;
   while(i == ace || i == pick) // Pętla aż do znalezienia
      i++;                      // damy do odsłonięcia.
   cards[i] = 'Q';
   print_cards("Odsłaniam damę", cards, pick);
invalid_choice = 1;
while(invalid_choice) {       // Pętla aż do dokonania wyboru.
   printf("Czy chcesz:\n[z]mienić wybór\tczy\t[p]owiększyć stawkę?\n");
   printf("Wybierz z lub p: ");
   choice_two = '\n';
   while(choice_two == '\n') // Usuń niepotrzebne nowe wiersze.
      scanf("%c", &choice_two);
   if(choice_two == 'p') {    // Powiększ stawkę.
         invalid_choice=0;    // To jest prawidłowy wybór.
         while(wager_two == -1)    // Pętla aż do podania prawidłowej stawki.
            wager_two = take_wager(player.credits, wager_one);
      }
   if(choice_two == 'z') {    // Zmiana wskazania karty.
      i = invalid_choice = 0; // Prawidłowy wybór
      while(i == pick || cards[i] == 'Q') // Pętla do znalezienia 
         i++;                              // innej karty,
      pick = i;                            // a następnie zamiana wyboru.
      printf("Zmieniłeś wskazanie karty na %d\n", pick+1);
   }
}

for(i=0; i < 3; i++) { // Odkryj wszystkie karty.
   if(ace == i)
      cards[i] = 'A';
   else
      cards[i] = 'Q';
}
print_cards("Wynik", cards, pick);

if(pick == ace) { // Obsłuż wygraną.
   printf("Wygrałeś %d kredytów z pierwszego zakładu\n", wager_one);
   player.credits += wager_one;
   if(wager_two != -1) {
      printf("i dodatkowe %d kredytów z drugiego zakładu!\n", wager_two);
      player.credits += wager_two;
   }
} else { // Obsłuż przegraną.
   printf("Przegrałeś %d kredytów z pierwszego zakładu\n", wager_one);
   player.credits -= wager_one;
   if(wager_two != -1) {
      printf("i dodatkowe %d kredytów z drugiego zakładu!\n", wager_two);
      player.credits -= wager_two;
   }
}
return 0;
}
