#include <stdio.h>

#include <stdlib.h>

#include <string.h>



void *errorchecked_malloc(unsigned int); // Prototyp funkcji errorchecked_malloc()



int main(int argc, char *argv[]) {

   char *char_ptr; // Wskaźnik typu char

   int *int_ptr;    // Wskaźnik typu int

   int mem_size;



   if (argc < 2)     // Jeżeli w wierszu polecenia nie podano argumentów

      mem_size = 50; // użyj 50 jako wartości domyślnej.

   else

      mem_size = atoi(argv[1]);



   printf("\t[+] alokuję %d bajtów pamięci na stercie dla char_ptr\n", mem_size);

   char_ptr = (char *) errorchecked_malloc(mem_size); // Alokacja pamięci na stercie



   strcpy(char_ptr, "Ta pamięć znajduje się na stercie.");

   printf("char_ptr (%p) --> '%s'\n", char_ptr, char_ptr);

   printf("\t[+] alokuję 12 bajtów pamięci na stercie dla int_ptr\n");

   int_ptr = (int *) errorchecked_malloc(12); // Ponownie alokowana pamięć na stercie



   *int_ptr = 31337; // Umieszcza wartość 31337 w miejscu wskazywanym przez int_ptr

   printf("int_ptr (%p) --> %d\n", int_ptr, *int_ptr);



   printf("\t[-] zwalniam pamięć sterty przydzieloną char_ptr's...\n");

   free(char_ptr); // Zwalniana pamięć sterty



   printf("\t[+] alokuję kolejne 15 bajtów dla char_ptr\n");

   char_ptr = (char *) errorchecked_malloc(15); // Dalsza alokacja pamięci sterty



   strcpy(char_ptr, "nowa pamięć");

   printf("char_ptr (%p) --> '%s'\n", char_ptr, char_ptr);



   printf("\t[-] zwalniana pamięć sterty dla int_ptr...\n");

   free(int_ptr); // Zwalnianie pamięci heap

   printf("\t[-] zwalnainie pamięci sterty dla char_ptr...\n");

   free(char_ptr); // Zwalnianie innego bloku pamięci sterty

}



void *errorchecked_malloc(unsigned int size) { // Funkcja malloc() ze sprawdzeniem błędów

   void *ptr;

   ptr = malloc(size);

   if(ptr == NULL) {

      fprintf(stderr, "Błąd: nie można alokować pamięci na stercie.\n");

      exit(-1);

   }

   return ptr;

}
