#define _XOPEN_SOURCE
#include <unistd.h>
#include <stdio.h>

/* Wypisuje kominikat i kończy pracę */
void barf(char *message, char *extra) {
   printf(message, extra);
   exit(1);
}

/* przykładowy program przeprowadzający atak słownikowy */
int main(int argc, char *argv[]) {
   FILE *wordlist;
   char *hash, word[30], salt[3];
   if(argc < 2) 
      barf("Sposób użycia: %s <plik z listą słów> <skrót hasła>\n", argv[0]);

   strncpy(salt, argv[2], 2); // pierwsze 2 bajty skrótu są wartością salt
   salt[2] = '\0';  // kończy łańcuch

   printf("Wartosc salt wynosi \'%s\'\n", salt);

   if( (wordlist = fopen(argv[1], "r")) == NULL) // otwiera listę słów
      barf("Błąd krytyczny: Nie można otworzyć pliku \'%s\'.\n", argv[1]);
   
   while(fgets(word, 30, wordlist) != NULL) { // czytaj każde słowo
      word[strlen(word)-1] = '\0'; // usuń z końca bajt '\n' 
      hash = crypt(word, salt); // utwórz skrót słowa z użyciem wartości salt
      printf("próbuję słowo:   %-30s ==> %15s\n", word, hash);
      if(strcmp(hash, argv[2]) == 0) { // jeżeli skróty są identyczne
         printf("\"%s\" jest skrótem ", argv[2]);
         printf("następującego hasła: \"%s\".\n", word);
         fclose(wordlist);
         exit(0);
      }
   }
   printf("Nie odnaleziono odkodowanego hasła na dostarczonej liście słów.\n");
   fclose(wordlist);
}
