﻿using System;

namespace ch1_the_basics_advanced
{
    public class PoliceOfficer : PublicServant, IPerson
    {
        private bool _hasEmergency = false;

        public PoliceOfficer(string name, int age, bool hasEmergency = false)
        {
            this.Name = name;
            this.Age = age;
            this.HasEmergency = hasEmergency;

            if (this.HasEmergency)
            {
                this.DriveToPlaceOfInterest += delegate
                {
                    Console.WriteLine("Jazda pojazdem policyjnym na syrenie");
                    GetInPoliceCar();
                    TurnOnSiren();
                    FollowDirections();
                };
            }
            else
            {
                this.DriveToPlaceOfInterest += delegate
                {
                    Console.WriteLine("Jazda pojazdem policyjnym");
                    GetInPoliceCar();
                    FollowDirections();
                };
            }
        }

        //implementacja interfejsu IPerson
        public string Name { get; set; }
        public int Age { get; set; }

        public bool HasEmergency
        {
            get { return _hasEmergency; }
            set { _hasEmergency = value; }
        }

        private void GetInPoliceCar() { }
        private void TurnOnSiren() { }
        private void FollowDirections() { }
    }
}

