import turtle


# importujemy moduł turtle


def spirala(x, y, kat, a, n, kolory):
    # tworzymy funkcję o nazwie spirala
    # funkcja ta przyjmuje 6 argumentów
    # pierwsze dwa to pozycja żółwia,
    # gdzie ma zostać rozpoczęte rysowanie spirali 
    # kolejny to kąt, następny argument to rozmiar 
    # najkrótszego boku spirali,
    # parametr n oznacza liczbę boków spirali
    # ostatni argument powinien mieć postać listy 
    # lista ta powinna zawierać kolory 
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za 
    # sobą śladu w postaci linii 
    turtle.setheading(kat)
    # ustawiamy, w którą stronę
    # ma być zwrócony żółw, gdzie wartość 0
    # oznacza w prawo, 90 to pionowo w górę
    # 180 w lewo, a 270 w dół
    turtle.goto(x, y)
    # przemieszczamy żółwia do wskazanej pozycji
    # określonej przez zmienne x oraz y
    turtle.pendown()
    # opuszczamy żółwia, od tej pory
    # poruszając się, pozostawiamy za
    # sobą ślad w postaci linii 
    turtle.pensize(4)
    # ustawiamy rozmiar linii, którą rysuje żółw, 
    # na wartość równą 4 piksele
    for i in range(n + 1, -1, -1):
        # pętla wykona się n+2 razy
        # warto zwrócić uwagę, że wartości zmiennej
        # i będą wynosić od wartości n+1 aż do 0 włącznie
        # z każdym obrotem pętli wartość zmiennej
        # i zostaje zmniejszona o 1 
        turtle.pencolor(kolory[i % len(kolory)])
        # ustawiamy kolor linii na wartość z listy
        # o nazwie kolory, dzięki operatorowi modulo
        # jesteśmy w stanie zapętlić kolory,
        # tak aby po kolorze purple żółw rysował kolorem
        # orange, czyli pomarańczowym
        turtle.forward(a * i)
        # przesuwamy żółwia do przodu o wartość zmiennej a 
        # pomnożoną przez wartość zmiennej i
        # warto zwrócić uwagę, że zmienna i z każdym obrotem 
        # pętli jest zmniejszana o jeden,
        # rysowane są coraz krótsze odcinki 
        turtle.left(90)
        # obracamy żółwia o 90 stopni w lewo


spirala(0, 0, 0, 10, 20, ["orange", "green", "purple"])
spirala(0, 0, 90, 10, 20, ["orange", "green", "purple"])
spirala(0, 0, 180, 10, 20, ["orange", "green", "purple"])
spirala(0, 0, 270, 10, 20, ["orange", "green", "purple"])
# wywołujemy czterokrotnie funkcję spirala
# każde z wywołań różni się tylko wartością parametru
# określającego kąt, pod jakim ma zostać narysowana spirala 
# wszystkie spirale posiadają krawędzie w kolorach
# pomarańczowym, zielonym oraz fioletowym

turtle.mainloop()
# zapobiegamy zamknięciu się okna 
# po narysowaniu rysunku
