;code by jasper/stc
.386
JUMPS
ASSUME	CS:CODE,SS:STACKS
CODE	SEGMENT USE16
ile_pix	equ 8			;ilosc punktow
ile_lin	equ 12			;ilosc linii
d_x	dw 160			;korekcja X
d_y	dw 100			;korekcja Y
katx	dw 0			;\
katy	dw 0			; >katy obrotow wokol trzech osi
katz	dw 0			;/
dist	dw 6000			;odleglosc od obserwatora
include	linia.asm		;dolacz procedure rusujaca linie
Begin:
	mov ax,0013h
	int 10h			;ustaw tryb 13h 320x200x256c
Petla:
	call	Ramka		;kontrola ramki
	call	Przesun		;kopiuj dane do tablicy pomocniczej
	call	Rotates		;obroc punkty
	call	Rysuj		;rysuj sciany
	call	Zmien		;zmien strony
	call	Czysc		;czysc bufor
	call	Z_katy		;uaktualnij katy
	mov	ah,01h
	int	16h
	jz	petla		;czekaj na klawisz
	mov	ax,0003h
	int	10h		;ustaw tryb tekstowy
	mov	ax,4c00h
	int	21h		;wyjdz do DOSu
Ramka	PROC			;kontrola ramki
	mov	dx,3dah
Ram1:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jnz	ram1		;jezeli nie zero to skok
Ram2:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jz	ram2		;jezeli zero to skok
	ret
Ramka	ENDP
Przesun	PROC			;skopiuj dane do tablicy pomocniczej
        mov     dx,seg bryla
        mov     ds,dx		;z tablicy bryla
        lea     si,bryla
        mov     dx,seg wsp3d
        mov     es,dx		;do tablicy wsp3d
        lea     di,wsp3d
        mov     cx,ile_pix 
        mov     bx,cx 
        add     cx,bx 
        add     cx,bx 
        cld 
        rep     movsw		;kopiuj
        ret 
Przesun	ENDP
Rysuj	PROC			;rysuj linie
	mov	dx,seg lacz
	mov	es,dx		;dane o polaczeniach w tablicy lacz
	lea	di,lacz
	mov	dx,seg wsp2d
	mov	ds,dx		;wspolrzedne wierzcholkow w tablicy wsp2d
	lea	si,wsp2d
	mov	cx,ile_lin	;rysuj ile_lin linii
Rys:
	mov	bx,es:[di]	;wczytaj numer pierwszego wierzcholka
	shl	bx,2
	mov	ax,ds:[si][bx]	;wspolrzedna x
	mov	x1,ax
	mov	ax,ds:[si][bx][2] ;wspolrzedna y
	mov	y1,ax
	mov	bx,es:[di][2]	;wczytaj numer drugiego wierzcholka
	shl	bx,2
	mov	ax,ds:[si][bx]	;wspolrzedna x
	mov	x2,ax
	mov	ax,ds:[si][bx][2] ;wspolrzedna y
	mov	y2,ax
	pusha
	push	es
	mov	dx,seg bufor
	mov	es,dx		;rysuj linie w buforze
	call	Linia		;rysuj
	pop	es
	popa
	add	di,4		;nastepna linia
	loop	rys
	ret
Rysuj	ENDP
Zmien	PROC			;kopiuj zawartosc bufora na ekran  
	mov	dx,seg bufor
	mov	ds,dx		;czytaj z bufora
	mov	si,0
	mov	dx,0a000h
	mov	es,dx		;zapisuj na ekran
	mov	di,0
	mov	eax,0
	mov	cx,64000/4	;64000 bajty
	cld
	rep	movsd		;kopiuj
	ret
Zmien	ENDP
Czysc	PROC			;czysc bufor
	mov	dx,seg bufor
	mov	es,dx
	mov	di,0
	mov	eax,0		;czysc kolorem zerowym
	mov	cx,64000/4	;bufor ma dlugosc 64000 bajtow
	rep	stosd		;czysc
	ret
Czysc	ENDP
Z_katy	PROC			;uaktualnij katy
	add	katx,1		;kat obrotu wokol osi OX
	cmp	katx,360
	jb	okx
	mov	katx,0
Okx:
	add	katy,1		;OY
	cmp	katy,360
	jb	oky
	mov	katy,0
Oky:
	add	katz,1		;OZ
	cmp	katz,360
	jb	okz
	mov	katz,0
Okz:
	ret
Z_katy	ENDP

include 3d_math.inc		;dolacz procedury na obroty i perspektywe
include sinus.inc		;dolacz tablice sinusow
include cosinus.inc		;i cosinusow
;tablica wspolrzednych wierzcholkow bryly
bryla	dw -1000,-1000, 1000,	 1000,-1000, 1000
	dw  1000, 1000, 1000,	-1000, 1000, 1000
    	dw -1000,-1000,-1000,	 1000,-1000,-1000
	dw  1000, 1000,-1000,	-1000, 1000,-1000
;tablica polaczen
lacz	dw 0,1, 1,2, 2,3, 3,0, 4,5, 5,6, 6,7, 7,4, 0,4, 1,5, 2,6, 3,7
CODE ENDS

BUF 	SEGMENT USE16
Bufor	dw 32000 dup(0)		;zdefiniuj bufor
BUF	ENDS 

STACKS	SEGMENT USE16 STACK 'STACK'
db 512	dup (0)			;a teraz stos
STACKS	ENDS	

END Begin
