;code by jasper/stc
.386
JUMPS
ASSUME	CS:CODE,SS:STACKS
CODE	SEGMENT USE16
katx	dw 0			;\
katy	dw 0			; >katy obrotow wokol trzech osi
katz	dw 0			;/
ile_pix	equ 8			;ilosc punktow
ile_sci	equ 12			;ilosc scian
dist	dw 6000			;odleglosc od obserwatora
d_x	dw 160			;korekcja X
d_y	dw 100			;korekcja Y
kol	dw ile_pix dup(0)	;tablica wartosci kolorow
include scianag.asm
Begin:
	mov	ax,0013h
	int	10h		;ustaw tryb 13h 320x200x256c
	mov	dx,seg pal	;\
	mov	ds,dx		; >ustaw
	lea	si,pal		; >palete
	call	Paleta		;/
Petla:
	call	Ramka		;kontrola ramki
	call	Przesun		;kopiuj dane do tablicy pomocniczej
	call	Rotates		;obracaj punkty
	call	Kolory		;zapisz kolory wierzcholkow
	call	Rysuj		;rysuj sciany
	call	Zmien		;zmien strony
	call	Czysc		;czysc bufor
	call	Z_katy		;uaktualnij katy
	mov	ah,01h
	int	16h
	jz 	petla		;czekaj na klawisz
	mov	ax,0003h
	int	10h		;ustaw tryb tekstowy
	mov	ax,4c00h
	int	21h		;wyjscie do DOSu
Ramka	PROC			;kontrola ramki
	mov	dx,3dah
Ram1:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jnz	ram1		;jezeli nie zero to skok
Ram2:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jz	ram2		;jezeli zero to skok
	ret
Ramka	ENDP
Paleta	PROC			;ustawianie palety DS:SI-rzadana paleta
	mov	cx,256*3	;ustaw 256 kolorow
	mov	dx,3c8h
	mov	al,0		;zacznij od zerowego
	out	dx,al
	inc	dx
	cld
	rep	outsb		;wysylaj dane do portu
	ret
Paleta	ENDP
Przesun	PROC			;skopiuj dane do tablicy pomocniczej
        mov     dx,seg bryla
        mov     ds,dx		;z tablicy bryla
        lea     si,bryla
        mov     dx,seg wsp3d
        mov     es,dx		;do tablicy wsp3d
        lea     di,wsp3d
        mov     cx,ile_pix 
        mov     bx,cx 
        add     cx,bx 
        add     cx,bx 
        cld 
        rep     movsw		;kopiuj
        ret 
Przesun	ENDP
Kolory	PROC			;zapisz kolory wierzcholkow
	mov	dx,seg wsp3d	;\
	mov	ds,dx		; >na podstawie tablicy wsp3d
	lea	si,wsp3d	;/
	mov	dx,seg kol	;\
	mov	es,dx		; >zapisuj do tablicy kol
	lea	di,kol		;/
	mov	cx,ile_pix
Kolo:
	mov	ax,ds:[si][4]	;wczytaj wspolrzedna Z
	neg	ax		;\
	add	ax,1500		; >odpowiednio ja przeksztalc
	shr	ax,5		;/
	stosw			;zapisz wartosc koloru
	add	si,6
	loop	kolo		;kolejny punkt
	ret
Kolory	ENDP
Rysuj	PROC
	mov	dx,seg wsp2d
	mov	es,dx		;wspolrzedne wierzcholkow w tablicy wsp2d
	lea	di,wsp2d
	mov	dx,seg kol
	mov	fs,dx		;kolory wierzcholkow w tablicy kol
	lea	si,kol
	mov	dx,seg lacz
	mov	ds,dx		;dane o polaczeniach w tablicy lacz
	lea	bp,lacz
	mov	cx,ile_sci	;rysuj ile_sci scian
Rys:
	push	cx
	mov	bx,ds:[bp]		;wczytaj numer pierwszego wierzcholka
	shl	bx,1
	movsx	eax,word ptr fs:[si][bx]	;wczytaj wartosc koloru 
	mov	k1,eax
	shl	bx,1
	movsx	eax,word ptr es:[di][bx]	;wczytaj wspolrzedna x
	mov	x1,eax
	movsx	eax,word ptr es:[di][bx][2]	;wczytaj wspolrzedna y
	mov	y1,eax
	mov	bx,ds:[bp][2]	;wczytaj numer drugiego wierzcholka
	shl	bx,1
	movsx	eax,word ptr fs:[si][bx]	;wczytaj wartosc koloru
	mov	k2,eax
	shl	bx,1
	movsx	eax,word ptr es:[di][bx]	;wczytaj wspolrzedna x
	mov	x2,eax
	movsx	eax,word ptr es:[di][bx][2]	;wczytaj wspolrzedena y
	mov	y2,eax
	mov	bx,ds:[bp][4]	;wczytaj numer trzeciego wierzcholka
	shl	bx,1
	movsx	eax,word ptr fs:[si][bx]	;wczytaj wartosc koloru
	mov	k3,eax
	shl	bx,1
	movsx	eax,word ptr es:[di][bx]	;wczytaj wspolrzedna x
	mov	x3,eax
	movsx	eax,word ptr es:[di][bx][2]	;wczytaj wspolrzedna y
	mov	y3,eax
;sprawdz widocznosc sciany
	mov	ax,word ptr x1	;\
	sub	ax,word ptr x2	; >oblicz wartosc wyrazenia
	mov	bx,word ptr y3	; >(x1-x2)*(y3-y2)
	sub	bx,word ptr y2	;/
	imul	bx
	shl	edx,16
	mov	dx,ax
	push	edx
	mov	ax,word ptr x2	;\
	sub	ax,word ptr x3	; >oblicz wartosc wyrazenia
	mov	bx,word ptr y2	; >(x2-x3)*(y2-y1)
	sub	bx,word ptr y1	;/
	imul	bx
	shl	edx,16
	mov	dx,ax
	pop	ebx
	sub	ebx,edx		;oblicz (x1-x2)*(y3-y2)-(x2-x3)*(y2-y1)
	cmp	ebx,0		;porownaj to do zera
	jl	bezscia		;jezeli mniejsze to nie rysuj sciany
	push	ds
	push	es
	pusha
	mov	dx,seg bufor
	mov	es,dx		;rysuj w buforze
	call	Scianag
	popa
	pop	es
	pop	ds
Bezscia:
	add	bp,8
	pop	cx
	loop	rys
	ret
Rysuj	ENDP
Zmien	PROC			;kopiuj zawartosc bufora na ekran  
	mov	dx,seg bufor
	mov	ds,dx		;czytaj z bufora
	mov	si,0
	mov	dx,0a000h
	mov	es,dx		;zapisuj na ekran
	mov	di,0
	mov	eax,0
	mov	cx,64000/4	;64000 bajty
	cld
	rep	movsd		;kopiuj
	ret
Zmien	ENDP
Czysc	PROC			;czysc bufor
	mov	dx,seg bufor
	mov	es,dx
	mov	di,0
	mov	eax,0		;czysc kolorem zerowym
	mov	cx,64000/4	;bufor ma dlugosc 64000 bajtow
	rep	stosd		;czysc
	ret
Czysc	ENDP
Z_katy	PROC			;uaktualnij katy
	add	katx,1		;kat obrotu wokol osi OX
	cmp	katx,360
	jb	okx
	mov	katx,0
Okx:
	add	katy,1		;OY
	cmp	katy,360
	jb	oky
	mov	katy,0
Oky:
	add	katz,1		;OZ
	cmp	katz,360
	jb	okz
	mov	katz,0
Okz:
	ret
Z_katy	ENDP
include 3d_math.inc		;dolacz procedury na obroty i perspektywe
include sinus.inc		;dolacz tablice sinusow
include cosinus.inc		;i cosinusow
Pal:
include gouraud.pal		;dolacz palete

;tablica polaczen
lacz	dw 0,1,2,1,  2,3,0,1,  7,6,5,1,  5,4,7,1,  1,5,6,2,  6,2,1,2
	dw 4,0,3,2,  3,7,4,2,  1,0,4,3,  4,5,1,3,  2,6,7,3,  7,3,2,3
;tablica wspolrzednych wierzcholkow bryly
bryla	dw -1000,-1000, 1000,	 1000,-1000, 1000
	dw  1000, 1000, 1000,	-1000, 1000, 1000
	dw -1000,-1000,-1000,	 1000,-1000,-1000
	dw  1000, 1000,-1000,	-1000, 1000,-1000
CODE	ENDS

BUF	SEGMENT USE16
Bufor dw 32000 dup(0)		;zdefiniuj bufor
BUF	ENDS

STACKS	SEGMENT USE16 STACK 'STACK'
db	512 dup(0)		;i stos
STACKS	ENDS

END	Begin
