;code by jasper/stc
.386
JUMPS
ASSUME	cs:CODE,ss:STACKS
 
CODE	SEGMENT USE16
ile_pix	equ 648			;ilosc rysowanych punktow
dist	dw 2500			;odleglosc od obserwatora
katx	dw 0			;kat obrotu wokol osi OX
katy    dw 0			;osi OY
katz	dw 0			;osi OZ
d_x     dw 160			;korekcja X
d_y     dw 100			;korekcja Y

Begin:
	mov	ax,0013h
	int	10h		;ustaw tryb 13h, 320x200x256c
Petla:
	call	Ramka		;kontrola ramki
        call    Przesun		;skopiuj dane do tablicy pomocniczej
        call    Rotates		;obroc punkty
	call	Rysuj		;rysuj je
	call	Zmien		;zmien strone
	call	Czysc		;czysc ekran
	call	Z_katy		;uaktualnij katy
        mov     ah,01h
        int     16h
        jz      Petla		;oczekiwanie na klawisz
	mov	ax,0003h
	int	10h		;ustaw tryb tekstowy
	mov	ax,4c00h
	int	21h		;wyjscie do DOSu
Ramka	PROC			;kontrola ramki
	mov	dx,3dah
Ram1:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jnz	ram1		;jezeli nie zero to skok
Ram2:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jz	ram2		;jezeli zero to skok
	ret
Ramka	ENDP
Przesun	PROC			;skopiuj dane do tablicy pomocniczej
        mov     dx,seg bryla
        mov     ds,dx		;z tablicy bryla
        lea     si,bryla
        mov     dx,seg wsp3d
        mov     es,dx		;do tablicy wsp3d
        lea     di,wsp3d
        mov     cx,ile_pix 
        mov     bx,cx 
        add     cx,bx 
        add     cx,bx 
        cld 
        rep     movsw		;kopiuj
        ret 
Przesun	ENDP
Z_katy	PROC			;uaktualnij katy
	add	katx,1		;kat obrotu wokol osi OX
	cmp	katx,360
	jb	okx
	mov	katx,0
Okx:
	add	katy,1		;OY
	cmp	katy,360
	jb	oky
	mov	katy,0
Oky:
	add	katz,1		;OZ
	cmp	katz,360
	jb	okz
	mov	katz,0
Okz:
	ret
Z_katy	ENDP
Czysc	PROC			;czysc bufor ekranu
	mov	dx,seg bufor
	mov	es,dx
	mov	dx,seg ofs	;offsety sa w tablicy ofs
	mov	ds,dx
	lea	si,ofs
	mov	eax,0
	mov	cx,ile_pix	;wyczysc ile_pix punktow
Cz:
	lodsw
	mov	es:[eax],byte ptr 0	;czysc punkt
	loop	cz
	ret
Czysc	ENDP
Rysuj	PROC			;rysuj punkty    
	mov	dx,seg wsp2d
	mov	ds,dx		;w tablicy wsp2d sa ich wspolrzedne
	lea	si,wsp2d
	lea	bp,ofs		;tu beda ich offsety
	mov	dx,seg bufor
	mov	es,dx		;punkty rysowane sa w buforze 
	mov	cx,ile_pix	;rysuj ile_pix punktow
Rys:
	mov	di,ds:[si]	;wczytaj wspolrzedna X
	mov	ax,ds:[si][2]	;Y 
	cmp	di,0		;\
	jl	bezp		; \
	cmp	di,320		;  \
	jg	bezp		;   >sprawdz, czy wspolrzedne nie
	cmp	ax,0		;   >wychodza poza ekran
	jl	bezp		;  /
	cmp	ax,200		; /
	jg	bezp		;/
	xchg	ah,al		;\
	add	di,ax		; >oblicz wyrazenie
	shr	ax,2		; >320*y+x
	add	di,ax		;/
	mov	al,15
	mov	es:[di],al	;stawiaj punkt
	mov	ds:[bp],di	;zapisz jego offset
Bezp:
	add	si,4
	add	bp,2
	loop	rys
	ret
Rysuj	ENDP
Zmien	PROC			;kopiuj zawartosc bufora na ekran  
	mov	dx,seg bufor
	mov	ds,dx		;czytaj z bufora
	mov	si,0
	mov	dx,0a000h
	mov	es,dx		;zapisuj na ekran
	mov	di,0
	mov	eax,0
	mov	cx,64000/4	;64000 bajty
	cld
	rep	movsd		;kopiuj
	ret
Zmien	ENDP

include 3d_math.inc		;dolacz procedury na obroty i perspektywe
ofs	dw ile_pix dup(0)	;miejsce na offsety rysowanych punktow
include sinus.inc		;dolacz tablice sinusow
include cosinus.inc		;i cosinusow
Bryla:
include punkty.inc		;dolacz wspolrzedne bryly
CODE	ENDS 
 
BUF 	SEGMENT USE16
Bufor	dw 32000 dup(0)		;zdefiniuj bufor
BUF	ENDS 

STACKS	SEGMENT USE16 STACK 'STACK'
db 512	dup (0)			;a teraz stos
STACKS	ENDS	
 
END	Begin			;koniec
